/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.ARCommonConfigKey;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.bmc.thirdparty.org.apache.commons.configuration.DefaultConfigurationBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ARCommonConfig {
    private static Logger log = Logger.getLogger(ARCommonConfig.class);
    private static final ARCommonConfig _theInstance = new ARCommonConfig();
    private boolean logBytes;
    private HashMap<String, String> catalogItems = new HashMap();
    static final String AR_MSG_SET_ATTR_NAME = "msgSet";
    static final String AR_CATALOG_MSG_SET_ID = "1";

    private ARCommonConfig() {
        try {
            this.applyDefaults();
        }
        catch (Exception e) {
            log.error("Can not initialize Config defaults", e);
        }
        try {
            this.applyConfigFileSettings("arsys_base.xml");
        }
        catch (Exception e) {
            log.error("Can not initialize Config from file" + e.getLocalizedMessage());
        }
    }

    public static ARCommonConfig getInstance() {
        return _theInstance;
    }

    private void applyDefaults() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        this.logBytes = Boolean.parseBoolean(ARCommonConfigKey.LogBytes.getDefaultValue());
        this.catalogItems = new HashMap();
    }

    private void applyConfigFileSettings(String fileName) throws ConfigurationException {
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder(fileName);
        factory.clearErrorListeners();
        Configuration config = factory.getConfiguration();
        this.logBytes = config.getBoolean(ARCommonConfigKey.LogBytes.getKey(), this.logBytes);
        if (this.logBytes) {
            log.info("setlogBytes : " + this.logBytes);
        }
        List<Object> catalogs = config.getList(ARCommonConfigKey.CatalogFileName.getKey());
        int i = 0;
        for (Object catalogFileName : catalogs) {
            String msgSetName = config.getString(ARCommonConfigKey.CatalogFileName.getKey() + "(" + i++ + ")[@" + AR_MSG_SET_ATTR_NAME + "]");
            if (msgSetName == null || msgSetName == "") {
                msgSetName = AR_CATALOG_MSG_SET_ID;
            }
            if (!this.catalogItems.containsKey(msgSetName)) {
                this.catalogItems.put(msgSetName, (String)catalogFileName);
                continue;
            }
            log.error("Catalog Message Set(" + msgSetName + ") already registered");
        }
    }

    public boolean getLogBytes() {
        return this.logBytes;
    }

    public String getCatalogFileName() {
        return this.getCatalogFileName(AR_CATALOG_MSG_SET_ID);
    }

    public String getCatalogFileName(String messageSetName) {
        return this.catalogItems.get(messageSetName);
    }

    public List<String> getMessageSetIds() {
        return new ArrayList<String>(this.catalogItems.keySet());
    }
}

