/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.devutility.catgen;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javax.xml.parsers.ParserConfigurationException;

public final class CatalogGen {
    private final Map<String, Map<Integer, String>> messageMap = new HashMap<String, Map<Integer, String>>();
    private final Map<String, File> fileSet = new HashMap<String, File>();
    private final Map<String, String> localeMap = new HashMap<String, String>();

    public static void main(String[] args) throws IOException, ParserConfigurationException {
        String inputDir = args[0];
        String outPutFile = args[1];
        String messageSet = args[2];
        int start = -1;
        if (args.length >= 4) {
            start = Integer.parseInt(args[3]);
        }
        int end = -1;
        if (args.length >= 5) {
            end = Integer.parseInt(args[4]);
        }
        CatalogGen instance = new CatalogGen();
        instance.populateLocales();
        instance.populateFileSet(inputDir);
        for (String key : instance.getFileSet().keySet()) {
            File file = instance.getFileSet().get(key);
            System.out.println("Processing file " + file.getAbsoluteFile());
            instance.processFile(key, file, "UTF-8", messageSet, start, end);
        }
        instance.exportToXML(outPutFile);
    }

    private void exportToXML(String fileName) throws IOException, ParserConfigurationException {
        for (String language : this.messageMap.keySet()) {
            String locale = this.localeMap.get(language.toUpperCase());
            if (locale == null || locale.length() <= 0 || fileName == null) continue;
            Properties props = new Properties();
            Map<Integer, String> idToNameMap = this.messageMap.get(language);
            for (Integer id : idToNameMap.keySet()) {
                props.setProperty(id.toString(), idToNameMap.get(id));
            }
            if (!fileName.endsWith(".xml")) continue;
            String outputFile = fileName.replace(".xml", "_" + locale + ".xml");
            System.out.println("Writing catalog: " + outputFile);
            FileOutputStream fos = new FileOutputStream(outputFile);
            props.storeToXML(fos, outputFile);
            fos.close();
        }
    }

    private void processFile(String key, File file, String charSet, String messageSet, int start, int end) throws FileNotFoundException {
        Map<Integer, String> idToNameMap = this.messageMap.get(key);
        if (idToNameMap == null) {
            idToNameMap = new HashMap<Integer, String>();
            this.messageMap.put(key, idToNameMap);
        }
        Scanner scan = "ENGLISH".equals(key.toUpperCase()) ? new Scanner(file) : new Scanner(file, charSet);
        String codeset = null;
        int set = 0;
        while (scan.hasNext()) {
            String str = scan.next();
            if (str.equals("$")) {
                String skip = scan.nextLine();
                Scanner comment = new Scanner(skip);
                comment.useDelimiter("=");
                if (!comment.hasNext() || !comment.next().equals(" codeset")) continue;
                codeset = comment.next();
                continue;
            }
            if (str.equals("$set")) {
                set = 0;
                if (scan.hasNextInt() && (set = scan.nextInt()) != Integer.parseInt(messageSet)) {
                    set = 0;
                }
                scan.nextLine();
                continue;
            }
            if (set != 0) {
                try {
                    String oldText;
                    String text;
                    int num = Integer.parseInt(str);
                    if (scan.hasNext()) {
                        text = scan.next();
                        if (scan.hasNextLine()) {
                            text = text + scan.nextLine();
                        }
                    } else {
                        text = "";
                    }
                    int i = 0;
                    do {
                        oldText = text;
                        text = oldText.replaceFirst("%[0-9a-zA-Z]+", "{" + i + "}");
                        ++i;
                    } while (!text.equals(oldText));
                    text = text.replace("`{", "\"{");
                    text = text.replace("'{", "\"{");
                    text = text.replace("}' ", "}\" ");
                    if (num < start || end != -1 && num > end) continue;
                    idToNameMap.put(num, text);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.out.println("str=" + str + ",Ignoring, not a message number");
                }
            }
            scan.nextLine();
        }
    }

    private void populateFileSet(String directory) {
        File dir = new File(directory);
        File[] subDirectories = dir.listFiles();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().equals("gencat");
            }
        };
        subDirectories = dir.listFiles(fileFilter);
        FilenameFilter uarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("uar.cat.src");
            }
        };
        FilenameFilter englishFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("ar.cat.src");
            }
        };
        for (File file : subDirectories) {
            File[] children;
            if ("ENGLISH".equals(file.getName().toUpperCase())) {
                for (File child : children = file.listFiles(englishFilter)) {
                    this.fileSet.put(file.getName(), child);
                }
                continue;
            }
            for (File child : children = file.listFiles(uarFilter)) {
                this.fileSet.put(file.getName(), child);
            }
        }
    }

    public Map<String, Map<Integer, String>> getMessageMap() {
        return this.messageMap;
    }

    public Map<String, File> getFileSet() {
        return this.fileSet;
    }

    public void populateLocales() {
        this.localeMap.put("CHINESE", Locale.CHINESE.getLanguage());
        this.localeMap.put("ENGLISH", Locale.ENGLISH.getLanguage());
        this.localeMap.put("FRENCH", Locale.FRENCH.getLanguage());
        this.localeMap.put("GERMAN", Locale.GERMAN.getLanguage());
        this.localeMap.put("ITALIAN", Locale.ITALIAN.getLanguage());
        this.localeMap.put("JAPANESE", Locale.JAPANESE.getLanguage());
        this.localeMap.put("KOREAN", Locale.KOREAN.getLanguage());
        this.localeMap.put("RUSSIAN", "ru");
        this.localeMap.put("SPANISH", "es");
    }
}

