/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.NetWorkDataKeyInfo;
import com.bmc.arsys.arencrypt.NetWorkDateEncTransferObject;

public class AREncryptAPISessionNodeBase {
    private transient NetWorkDateEncTransferObject dataEncRandomBytesObj = new NetWorkDateEncTransferObject();
    private transient NetWorkDataKeyInfo clntServerDataKey = null;
    private transient int sessionId;

    public AREncryptAPISessionNodeBase() {
        this.init();
    }

    public AREncryptAPISessionNodeBase(int encAlg) {
        this.init();
        this.dataEncRandomBytesObj.setAlg(encAlg);
    }

    private void init() {
        if (this.clntServerDataKey == null) {
            this.clntServerDataKey = new NetWorkDataKeyInfo();
        }
    }

    public AREncryptAPISessionNodeBase(int encAlg, byte[] svrBytes, byte[] clntBytes) {
        this(encAlg);
        this.dataEncRandomBytesObj.setClntRandBytes(clntBytes);
        this.dataEncRandomBytesObj.setServerRandBytes(svrBytes);
    }

    public AREncryptAPISessionNodeBase(int encAlg, byte[] svrBytes, byte[] clntBytes, byte[] preMaster) {
        this(encAlg);
        this.dataEncRandomBytesObj.setClntRandBytes(clntBytes);
        this.dataEncRandomBytesObj.setServerRandBytes(svrBytes);
        this.dataEncRandomBytesObj.setPreMasterKey(preMaster);
    }

    protected void setDataEncryptAlg(int dataEncryptAlg, int encryptPolicy, String serverName) throws AREncryptionException {
        dataEncryptAlg = this.clntServerDataKey.getCntDataKey().validateAlgAndPolicyForFipsModeCheck(dataEncryptAlg, encryptPolicy, serverName);
        if (encryptPolicy != 2) {
            this.getDataEncRandomBytesObj().setAlg(dataEncryptAlg);
            this.clntServerDataKey.getCntDataKey().setAlgorithmParam(dataEncryptAlg);
            this.clntServerDataKey.getSvrDataKey().setAlgorithmParam(dataEncryptAlg);
        }
    }

    protected void setClientRandBytes(byte[] bs) {
        this.getDataEncRandomBytesObj().setClntRandBytes(bs);
    }

    protected byte[] getClientRandBytes() {
        return this.getDataEncRandomBytesObj().getClntRandBytes();
    }

    protected void setServerRandBytes(byte[] serverRandBytes) {
        this.getDataEncRandomBytesObj().setServerRandBytes(serverRandBytes);
    }

    protected byte[] getPreMasterKey() {
        return this.getDataEncRandomBytesObj().getPreMasterKey();
    }

    protected void setPreMasterKey(byte[] preMasterKey) {
        this.getDataEncRandomBytesObj().setPreMasterKey(preMasterKey);
    }

    public NetWorkDataKeyInfo getClintKeyInfo() {
        return this.clntServerDataKey;
    }

    protected NetWorkDateEncTransferObject getDataEncRandomBytesObj() {
        return this.dataEncRandomBytesObj;
    }

    public void resetDataEncRandomBytesObj() {
        this.dataEncRandomBytesObj.setClntRandBytes(null);
        this.dataEncRandomBytesObj.setServerRandBytes(null);
        this.dataEncRandomBytesObj.setPreMasterKey(null);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int retSessionId) {
        this.sessionId = retSessionId;
    }

    protected boolean isAnEncryptedAPICall() {
        return false;
    }

    public void setServerClientDataKey(NetWorkDataKeyInfo datakey) {
        this.clntServerDataKey = datakey;
    }
}

