/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.Value;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SetFieldsFromFilterAPI
extends SetFieldsAction
implements ActiveLinkAction,
FilterAction,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3900257526767435755L;
    private String serviceName;
    private List<AssignInfo> inputAssignList;
    private int noMatchOption;
    private int multiMatchOption;

    public SetFieldsFromFilterAPI() {
        this(null, null, new ArrayList<FieldAssignInfo>());
    }

    public SetFieldsFromFilterAPI(String fromServer, String fromForm, List<FieldAssignInfo> fieldList) {
        super(fieldList);
        super.setFromServer(fromServer);
        super.setReadValuesFrom(fromForm);
    }

    public int getMultiMatchOption() {
        return this.multiMatchOption;
    }

    public void setMultiMatchOption(int multiMatchOption) {
        this.multiMatchOption = multiMatchOption;
    }

    public int getNoMatchOption() {
        return this.noMatchOption;
    }

    public void setNoMatchOption(int noMatchOption) {
        this.noMatchOption = noMatchOption;
    }

    public List<AssignInfo> getInputAssignList() {
        return this.inputAssignList;
    }

    public void setInputAssignList(List<AssignInfo> inputAssignList) {
        this.inputAssignList = inputAssignList;
    }

    public void addInputAssignment(int index, AssignInfo value) {
        List<AssignInfo> assignList = this.getInputAssignList();
        if (assignList == null) {
            this.setInputAssignList(new ArrayList<AssignInfo>());
            assignList = this.getInputAssignList();
        }
        assignList.add(index, value);
    }

    public void addInputAssignment(AssignInfo value) {
        this.addInputAssignment(this.getInputAssignList().size(), value);
    }

    private AssignInfo makeAssignInfo(Object value) {
        AssignInfo assignInfo = new AssignInfo();
        assignInfo.setAssignType(1);
        if (value instanceof Integer) {
            assignInfo.setValue(new Value((Integer)value));
        } else if (value instanceof Double) {
            assignInfo.setValue(new Value((Double)value));
        } else if (value instanceof String) {
            assignInfo.setValue(new Value((String)value));
        }
        return assignInfo;
    }

    public void addInputAssignment(int index, int value) {
        this.addInputAssignment(index, this.makeAssignInfo(value));
    }

    public void addInputAssignment(int value) {
        this.addInputAssignment(this.getInputAssignList().size(), value);
    }

    public void addInputAssignment(int index, double value) {
        this.addInputAssignment(index, this.makeAssignInfo(value));
    }

    public void addInputAssignment(double value) {
        this.addInputAssignment(this.getInputAssignList().size(), value);
    }

    public void addInputAssignment(int index, String value) {
        this.addInputAssignment(index, this.makeAssignInfo(value));
    }

    public void addInputAssignment(String value) {
        this.addInputAssignment(this.getInputAssignList().size(), value);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    static List<AssignInfo> buildInputAssignList(List<AssignInfo> assignList, ARServerUser ctx) throws ARException {
        if (assignList == null || assignList.size() <= 0 || !Config.getInstance().isStringizeFieldAssignments()) {
            return assignList;
        }
        String localForm = ctx.getSession().getCurrentLocalForm();
        int fieldId = 8;
        String remoteForm = ctx.getSession().getCurrentLocalForm();
        for (AssignInfo assignInfo : assignList) {
            assignInfo.prepareAssignmentString(ctx, localForm, fieldId, remoteForm);
        }
        return assignList;
    }

    @Override
    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        super.fromVariant(rawData, ctx);
    }

    void fixFieldAssignments(ARServerUser ctx) {
        SetFieldsFromFilterAPI.fixARAssignFieldStruct(this.getSetFieldsList(), this.getInputAssignList(), this.getServiceName(), 3, 6, ctx);
    }

    @Override
    Object toVariant(ARServerUser ctx) {
        Object[] var = (Object[])super.toVariant(ctx);
        return var;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SetFieldsFromFilterAPI obj = (SetFieldsFromFilterAPI)super.clone();
        if (this.inputAssignList != null) {
            int nLen = this.inputAssignList.size();
            obj.inputAssignList = new ArrayList<AssignInfo>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.inputAssignList.add((AssignInfo)this.inputAssignList.get(i).clone());
            }
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SetFieldsFromFilterAPI)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SetFieldsFromFilterAPI rhs = (SetFieldsFromFilterAPI)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.serviceName, rhs.serviceName).append(this.inputAssignList, rhs.inputAssignList).append(this.noMatchOption, rhs.noMatchOption).append(this.multiMatchOption, rhs.multiMatchOption).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.serviceName).append(this.inputAssignList).append(this.noMatchOption).append(this.multiMatchOption).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Service Name", this.serviceName).append("Input Assign List", this.inputAssignList).append("NoMatch Option", this.noMatchOption).append("MultiMatch Option", this.multiMatchOption).toString();
    }
}

