
package com.bmc.arsys.plugin.sample;

import java.util.ArrayList;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Constants;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
/**
 * A sample external authenticating plugin. This implementation extends AREAPlugin. 
 * Alternatively, one could just implement the interface AREAPluggable.   
 * 
 * This plugin just checks for a certain user name and returns a success for that user only, 
 * with a floating license.  
 *
 */
public class AREASample extends AREAPlugin{

    private static int count = 0;
    private ARPluginInfo pluginInfo = new ARPluginInfo("SAMPLE.AREA", this);

    /**
     * Checks for username "Good User" and authenticates him as a good user. 
     */
    public AREAResponse  areaVerifyLogin(
            ARPluginContext context, 
            String user,
            String password, 
            String networkAddress,
            String authString
            ) throws ARException{
        context.logMessage(pluginInfo, ARPluginContext.PLUGIN_LOG_LEVEL_INFO, "areaVerifyLogin()");
        AREAResponse resp = new AREAResponse();
        resp.setLoginStatus(AREAResponse.AREA_LOGIN_UNKNOWN_USER);
        if (user != null && user.equals("Good User")){
            resp.setLoginStatus(AREAResponse.AREA_LOGIN_SUCCESS);
            resp.setLicenseWrite(Constants.AR_LICENSE_TYPE_FLOATING);
            resp.setLogText("Log \"Good User\" is always welcome!");
            resp.setMessageText("Message to \"Good User\" -- WELCOME BACK! " + count++);
        }
        else{
            
            StatusInfo info = new StatusInfo(2, 1000, "Invalid user or password provided.", user);
            ArrayList<StatusInfo> list = new ArrayList<StatusInfo>();
            list.add(info);
            throw new ARException(list);
        }
        return resp;
    }
    
    /**
     * 
     * @param context
     * @return
     * @throws ARException
     */
    public boolean areaNeedSync(ARPluginContext context) throws ARException{
        context.logMessage(pluginInfo, ARPluginContext.PLUGIN_LOG_LEVEL_INFO, "areaNeedSync()");
        return true;
    }
    
}
