/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext.websocket.kaazing;

import com.bmc.arsys.arrpc.rpcext.NetworkSocket;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.NetworkWebSocketImpl;
import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.ByteSocket;
import com.kaazing.gateway.client.html5.ByteSocketEvent;
import com.kaazing.gateway.client.html5.ByteSocketListener;
import java.io.IOException;
import java.io.OutputStream;

public class WebSocketOutputStream
extends OutputStream
implements ByteSocketListener {
    private ByteSocket.ReadyState state = ByteSocket.ReadyState.CONNECTING;
    private final ByteSocket socket;
    private final NetworkSocket networkSocket;
    private ByteBuffer bb = new ByteBuffer();

    public WebSocketOutputStream(NetworkSocket networkSocket, ByteSocket socket) {
        this.networkSocket = networkSocket;
        this.socket = socket;
        socket.addByteSocketListener((ByteSocketListener)this);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ((NetworkWebSocketImpl)this.networkSocket).log(b, off, len, "WebSocketOutputStream.write() " + len + " bytes in byteBuffer");
        super.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        ByteBuffer byteBuffer = this.bb;
        synchronized (byteBuffer) {
            this.bb.putBytes(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        ByteBuffer byteBuffer = this.bb;
        synchronized (byteBuffer) {
            this.bb.put((byte)(0xFF & b));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.state.equals((Object)ByteSocket.ReadyState.CLOSED)) {
            this.networkSocket.connect();
        }
        ByteBuffer byteBuffer = this.bb;
        synchronized (byteBuffer) {
            this.bb.flip();
            try {
                ((NetworkWebSocketImpl)this.networkSocket).log("WebSocketOutputStream.flush() to call ByteSocket.send(byteBuffer)", null);
                this.socket.send(this.bb);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Error sending on socket");
                ioe.initCause(e);
                ((NetworkWebSocketImpl)this.networkSocket).log("Error sending on socket " + e.getMessage(), null);
                ioe.printStackTrace();
                throw ioe;
            }
            finally {
                this.bb.clear();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.bb.clear();
        this.state = ByteSocket.ReadyState.CLOSED;
    }

    public void onClose(ByteSocketEvent event) {
        this.state = ByteSocket.ReadyState.CLOSED;
    }

    public void onMessage(ByteSocketEvent event) {
    }

    public void onOpen(ByteSocketEvent event) {
        this.state = ByteSocket.ReadyState.OPEN;
    }
}

