/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext.websocket.kaazing;

import com.bmc.arsys.arrpc.rpcext.NetworkSocket;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.NetworkWebSocketImpl;
import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.ByteSocket;
import com.kaazing.gateway.client.html5.ByteSocketEvent;
import com.kaazing.gateway.client.html5.ByteSocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WebSocketInputStream
extends InputStream
implements ByteSocketListener {
    private List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private Object inputAvailable = new Object();
    private final NetworkSocket networkSocket;
    private ByteSocket.ReadyState state = ByteSocket.ReadyState.CONNECTING;
    private int timeout = 0;

    public WebSocketInputStream(NetworkSocket networkSocket, ByteSocket socket) {
        this.networkSocket = networkSocket;
        socket.addByteSocketListener((ByteSocketListener)this);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rtn = super.read(b, off, len);
        ((NetworkWebSocketImpl)this.networkSocket).log(b, off, len, "WebSocketInputStream.read() read in " + (len - off));
        return rtn;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.state.equals((Object)ByteSocket.ReadyState.CLOSED)) {
            this.networkSocket.connect();
        }
        boolean needToWait = false;
        Object object = this.buffers;
        synchronized (object) {
            if (this.buffers.size() != 0) {
                return this.getNextByte();
            }
            needToWait = true;
        }
        if (this.state.equals((Object)ByteSocket.ReadyState.OPEN) && needToWait && this.timeout > 0) {
            object = this.inputAvailable;
            synchronized (object) {
                try {
                    this.inputAvailable.wait(this.timeout);
                }
                catch (InterruptedException e) {
                    return -1;
                }
            }
        }
        object = this.buffers;
        synchronized (object) {
            return this.getNextByte();
        }
    }

    private int getNextByte() {
        int ret = 0;
        if (this.buffers.size() == 0) {
            if (this.state.equals((Object)ByteSocket.ReadyState.CLOSED)) {
                return -1;
            }
        } else {
            ByteBuffer bb = this.buffers.get(0);
            ret = bb.get() & 0xFF;
            if (!bb.hasRemaining()) {
                this.buffers.remove(0);
            }
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.buffers.clear();
        this.state = ByteSocket.ReadyState.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(ByteSocketEvent event) {
        this.state = ByteSocket.ReadyState.CLOSED;
        Object object = this.inputAvailable;
        synchronized (object) {
            this.inputAvailable.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ByteSocketEvent event) {
        ByteBuffer bb = event.getData();
        if (bb.hasRemaining()) {
            Object object = this.buffers;
            synchronized (object) {
                this.buffers.add(event.getData());
            }
            object = this.inputAvailable;
            synchronized (object) {
                this.inputAvailable.notify();
            }
        }
    }

    public void onOpen(ByteSocketEvent event) {
        this.state = ByteSocket.ReadyState.OPEN;
    }
}

