/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext.websocket.kaazing;

import com.bmc.arsys.arrpc.rpcext.ArOncRpcSocketClient;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.NetworkWebSocketImpl;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class WebSocketConnectionManager
extends Thread {
    private static Logger logger = Logger.getLogger(NetworkWebSocketImpl.class);
    private BlockingQueue<NetworkWebSocketImpl> queue = new ArrayBlockingQueue<NetworkWebSocketImpl>(100);
    private static final WebSocketConnectionManager instance = new WebSocketConnectionManager();

    public static WebSocketConnectionManager getInstance() {
        return instance;
    }

    private WebSocketConnectionManager() {
        this.start();
    }

    @Override
    public void run() {
        block5: {
            NetworkWebSocketImpl impl = null;
            try {
                while (true) {
                    impl = this.queue.take();
                    this.consume(impl);
                }
            }
            catch (InterruptedException ex) {
                if (impl != null && logger.isDebugEnabled()) {
                    ArOncRpcSocketClient.logNetworkMsg("connect to websocket failed InterruptedException " + ex.getMessage(), impl.id, ex);
                }
            }
            catch (IOException e) {
                if (impl == null || !logger.isDebugEnabled()) break block5;
                ArOncRpcSocketClient.logNetworkMsg("connect to websocket failed w IOException " + e.getMessage(), impl.id, e);
            }
        }
    }

    void consume(NetworkWebSocketImpl socketImplInstance) throws IOException {
        socketImplInstance.blockedConnect();
    }

    void produce(NetworkWebSocketImpl socketImplInstance) {
        try {
            this.queue.put(socketImplInstance);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unexpected interruption " + iex.getMessage());
        }
    }
}

