/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArFlexXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArFlexXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.rpcext.ArOncRpcTcpClient;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.apache.log4j.Logger;

public class ArFlexOncRpcTcpClient
extends ArOncRpcTcpClient {
    private static Logger log = Logger.getLogger(ArFlexOncRpcTcpClient.class);
    protected int minXdrEncodingStreamSize = 4096;

    public ArFlexOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(arEncType, callContext, host, program, version, port, bufferSize, timeout);
    }

    public ArFlexOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize, int timeout, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(arEncType, callContext, host, program, version, port, bufferSize, timeout, networkSessionInfo);
    }

    public ArFlexOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        super(arEncType, callContext, host, program, version, port, bufferSize);
    }

    public ArFlexOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version) throws OncRpcException, IOException {
        super(arEncType, callContext, host, program, version);
    }

    public ArFlexOncRpcTcpClient(int arEncType, Object callContext, InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        super(arEncType, callContext, host, program, version, port);
    }

    public ArFlexOncRpcTcpClient(int arEncType, Object apiCxt, InetAddress host, int program, int version, int port, int xdrSize, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(arEncType, apiCxt, host, program, version, port, xdrSize, networkSessionInfo);
    }

    @Override
    protected void changeToArXdrStream(int arEncType, Object callContext, int arXdrSize) throws IOException, OncRpcException {
        super.changeToArXdrStream(arEncType, callContext, arXdrSize);
    }

    @Override
    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object obj, ArNetworkSocket socketWrapper, int senderLen) throws IOException {
        int bufferLen = this.minXdrEncodingStreamSize;
        this.sendingXdr = new ArFlexXdrTcpEncodingStream(socketWrapper, bufferLen);
        ((ArFlexXdrTcpEncodingStream)this.sendingXdr).setBufferSize(bufferLen);
        int rstLen = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).changeBufferIfNeeded(bufferLen, false);
        if (rstLen > 0) {
            ((ArFlexXdrTcpEncodingStream)this.sendingXdr).setBufferSize(rstLen);
        }
        this.reiterateSocketReceivingBufferSize(((ArFlexXdrTcpEncodingStream)this.sendingXdr).getMaxResponseSize());
        return this.sendingXdr;
    }

    @Override
    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object obj, ArNetworkSocket socketWrapper, int receiverLen) throws IOException {
        int bufferLen = this.minXdrEncodingStreamSize;
        this.receivingXdr = new ArFlexXdrTcpDecodingStream(socketWrapper, bufferLen);
        ((ArFlexXdrTcpDecodingStream)this.receivingXdr).setBufferSize(bufferLen);
        int rstLen = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).changeBufferIfNeeded(bufferLen, null);
        if (rstLen > 0) {
            ((ArFlexXdrTcpDecodingStream)this.receivingXdr).setBufferSize(rstLen);
        }
        this.reiterateSocketReceivingBufferSize(((ArFlexXdrTcpDecodingStream)this.receivingXdr).getMaxResponseSize());
        return this.receivingXdr;
    }

    public void reiterateSocketReceivingBufferSize(int size) {
        block2: {
            try {
                this.getSocketHelper().setReceiveBufferSize(size);
            }
            catch (Throwable e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)e.getMessage());
            }
        }
    }

    public void reiterateSocketSendingBufferSize(int size) {
        block2: {
            try {
                this.getSocketHelper().setSendBufferSize(size);
            }
            catch (Throwable e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)e.getMessage());
            }
        }
    }

    public void reiterateSocketBuffersSize() {
        this.reiterateSocketReceivingBufferSize(((ArFlexXdrTcpDecodingStream)this.receivingXdr).getMaxResponseSize());
        this.reiterateSocketSendingBufferSize(((ArFlexXdrTcpEncodingStream)this.sendingXdr).getMaxResponseSize());
    }

    protected void beginDecoding(int procedureNumber) throws IOException, OncRpcException {
        if (this.receivingXdr instanceof ArFlexXdrTcpDecodingStream && ((ArFlexXdrTcpDecodingStream)this.receivingXdr).isArProcessOn() && ((ArFlexXdrTcpDecodingStream)this.receivingXdr).isUseFlexXdrStreamBuffer()) {
            int bufferLen = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).getMaxResponseSize();
            int rstLen = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).changeBufferIfNeeded(bufferLen, null);
            if (rstLen > 0) {
                ((ArFlexXdrTcpDecodingStream)this.receivingXdr).setBufferSize(rstLen);
                bufferLen = rstLen;
                if (log.isTraceEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("beginDecoding for receiving call ").append(procedureNumber).append(", set Xdr receiving buffer size: ").append(bufferLen).append(" bytes");
                    log.trace((Object)msg.toString());
                }
            } else if (log.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder();
                int curSize = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).getBufferSize();
                msg.append("beginDecoding for receiving call ").append(procedureNumber).append(", keep Xdr receiving buffer size: ").append(curSize).append(" bytes");
                log.trace((Object)msg.toString());
            }
        }
        this.receivingXdr.beginDecoding();
    }

    protected void endDecoding(int procedureNumber) throws IOException, OncRpcException {
        super.endDecoding(procedureNumber);
        if (this.receivingXdr instanceof ArFlexXdrTcpDecodingStream && ((ArFlexXdrTcpDecodingStream)this.receivingXdr).isArProcessOn() && ((ArFlexXdrTcpDecodingStream)this.receivingXdr).isUseFlexXdrStreamBuffer()) {
            int reqBufferLen = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).getMarginSize();
            int bufferLen = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).changeBufferIfNeeded(reqBufferLen, null);
            if (bufferLen > 0) {
                ((ArFlexXdrTcpDecodingStream)this.receivingXdr).setBufferSize(bufferLen);
                if (log.isTraceEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("after receiving call ").append(procedureNumber).append(", reset Xdr receiving buffer size: ").append(bufferLen).append(" bytes");
                    log.trace((Object)msg.toString());
                }
            } else if (log.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder();
                int curSize = ((ArFlexXdrTcpDecodingStream)this.receivingXdr).getBufferSize();
                msg.append("after receiving call ").append(procedureNumber).append(", keep Xdr receiving buffer size: ").append(curSize).append(" bytes");
                log.trace((Object)msg.toString());
            }
        }
    }

    protected void beginEncoding(int procedureNumber, InetAddress receiverAddress, int receiverPort) throws IOException, OncRpcException {
        if (this.sendingXdr instanceof ArFlexXdrTcpEncodingStream && ((ArFlexXdrTcpEncodingStream)this.sendingXdr).isArProcessOn() && ((ArFlexXdrTcpEncodingStream)this.sendingXdr).isUseFlexXdrStreamBuffer()) {
            int reqBufferLen = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).getMaxResponseSize();
            int bufferLen = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).changeBufferIfNeeded(reqBufferLen, false);
            if (bufferLen > 0) {
                ((ArFlexXdrTcpEncodingStream)this.sendingXdr).setBufferSize(bufferLen);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("beginEncoding for sending call " + procedureNumber + ", set Xdr sending buffer size: " + bufferLen + " bytes"));
                }
            } else if (log.isTraceEnabled()) {
                int curSize = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).getBufferSize();
                log.trace((Object)("beginEncoding for sending call " + procedureNumber + ", keep Xdr sending buffer size: " + curSize + " bytes"));
            }
        }
        super.beginEncoding(procedureNumber, receiverAddress, receiverPort);
    }

    protected void endEncoding(int procedureNumber) throws IOException, OncRpcException {
        super.endEncoding(procedureNumber);
        if (this.sendingXdr instanceof ArFlexXdrTcpEncodingStream && ((ArFlexXdrTcpEncodingStream)this.sendingXdr).isArProcessOn() && ((ArFlexXdrTcpEncodingStream)this.sendingXdr).isUseFlexXdrStreamBuffer()) {
            int reqBufferLen = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).getMarginSize();
            int bufferLen = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).changeBufferIfNeeded(reqBufferLen, false);
            if (bufferLen > 0) {
                ((ArFlexXdrTcpEncodingStream)this.sendingXdr).setBufferSize(bufferLen);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("after sending call " + procedureNumber + ", reset Xdr sending buffer size: " + bufferLen + " bytes"));
                }
            } else if (log.isTraceEnabled()) {
                int curSize = ((ArFlexXdrTcpEncodingStream)this.sendingXdr).getBufferSize();
                log.trace((Object)("after sending call " + procedureNumber + ", keep Xdr sending buffer size: " + curSize + " bytes"));
            }
        }
    }

    public void setUseFlexXdrStreamBuffer(boolean useFlexXdrStreamBuffer) {
        ((ArFlexXdrTcpDecodingStream)this.receivingXdr).setUseFlexXdrStreamBuffer(useFlexXdrStreamBuffer);
        ((ArFlexXdrTcpEncodingStream)this.sendingXdr).setUseFlexXdrStreamBuffer(useFlexXdrStreamBuffer);
    }
}

