/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.common.AppException;
import com.bmc.arsys.common.CommonErrors;
import com.bmc.arsys.common.ErrorLoggingCriteria;
import com.bmc.arsys.common.LogTagger;
import com.bmc.arsys.utils.CatalogReader;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerHelper {
    private CatalogReader catalogReader;
    private Logger errorLogger;
    private ErrorLoggingCriteria errorLoggingCriteria;
    private LogTagger logTagger;
    private static final String WHITE_SPACE = " ";
    private static final String EXCEPTION = "Exception";
    private static final String EOL = System.getProperty("line.separator");
    private static final String EMPTY_STRING = "";
    private static final String APPENDED_TEXT_SEP = "; ";
    private static final String OPENING_BRACE = "(";
    private static final String CLOSING_BRACE = ")";
    private static final String[] serverMsgTags = new String[]{CommonErrors.AR_NOTE.toDefMsg(), CommonErrors.AR_WARN.toDefMsg(), CommonErrors.AR_ERROR.toDefMsg()};

    public LoggerHelper(CatalogReader catalogReader) {
        this.catalogReader = catalogReader;
    }

    public LoggerHelper(CatalogReader catalogReader, Logger logger) {
        this(catalogReader, logger, null);
    }

    public LoggerHelper(CatalogReader catalogReader, Logger logger, ErrorLoggingCriteria errorLoggingCriteria) {
        this(catalogReader, logger, errorLoggingCriteria, null);
    }

    public LoggerHelper(CatalogReader catalogReader, Logger logger, ErrorLoggingCriteria errorLoggingCriteria, LogTagger logTagger) {
        this.catalogReader = catalogReader;
        this.errorLogger = logger;
        this.errorLoggingCriteria = errorLoggingCriteria;
        this.logTagger = logTagger;
    }

    public void logFormattedMessage(boolean bl, Logger logger, Level level, int n, Object[] objectArray, String string, Locale locale) {
        if (bl) {
            this.logFormattedMessage(logger, level, n, objectArray, string, locale);
        }
    }

    public void logFormattedMessage(boolean bl, Logger logger, Level level, String string, int n, Object[] objectArray, String string2, Locale locale) {
        if (bl) {
            this.logFormattedMessage(logger, level, string, n, objectArray, string2, locale);
        }
    }

    public void logFormattedMessage(boolean bl, Logger logger, Level level, String string, Object[] objectArray, String string2, Locale locale) {
        if (bl) {
            this.logFormattedMessage(logger, level, string, objectArray, string2, locale);
        }
    }

    public void logFormattedMessage(boolean bl, Logger logger, Level level, String string, String string2, Object[] objectArray, String string3, Locale locale) {
        if (bl) {
            this.logFormattedMessage(logger, level, string, string2, objectArray, string3, locale);
        }
    }

    public void logFormattedMessage(Logger logger, Level level, int n, Object[] objectArray, String string, Locale locale) {
        this.logFormattedMessage(logger, level, null, n, objectArray, string, locale);
    }

    public void logFormattedMessage(Logger logger, Level level, String string, int n, Object[] objectArray, String string2, Locale locale) {
        if (logger.isEnabledFor((Priority)level)) {
            String string3 = string != null ? this.catalogReader.getMessage(string, n, objectArray, string2, locale) : this.catalogReader.getMessage(n, objectArray, string2, locale);
            this.logMessage(logger, level, n + WHITE_SPACE + string3);
        }
    }

    public void logFormattedMessage(Logger logger, Level level, String string, Object[] objectArray, String string2, Locale locale) {
        this.logFormattedMessage(logger, level, null, string, objectArray, string2, locale);
    }

    public void logFormattedMessage(Logger logger, Level level, String string, String string2, Object[] objectArray, String string3, Locale locale) {
        if (logger.isEnabledFor((Priority)level)) {
            String string4 = string != null ? this.catalogReader.getMessage(string, string2, objectArray, string3, locale) : this.catalogReader.getMessage(string2, objectArray, string3, locale);
            this.logMessage(logger, level, string2 + WHITE_SPACE + string4);
        }
    }

    private void logMessage(Logger logger, Level level, String string) {
        logger.log((Priority)level, (Object)string);
    }

    public void logException(Logger logger, Exception exception) {
        this.logException(true, logger, exception);
    }

    public void logException(boolean bl, Logger logger, Exception exception) {
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            if (bl) {
                logger.error((Object)EXCEPTION, (Throwable)exception);
            }
        } else {
            exception.printStackTrace();
        }
        if (this.errorLogger != null && (this.errorLoggingCriteria == null || this.errorLoggingCriteria.shouldLog(exception))) {
            String string;
            if (exception instanceof AppException && this.logTagger != null) {
                AppException appException = (AppException)exception;
                string = appException.getMessageSet() != null ? this.catalogReader.getMessage(appException.getMessageSet(), appException.getMessageId(), appException.getArgs(), appException.getDefaultMessage(), Locale.getDefault()) : this.catalogReader.getMessage(appException.getMessageId(), appException.getArgs(), appException.getDefaultMessage(), Locale.getDefault());
                string = string + this.logTagger.getTag(appException.getMessageId());
            } else if (exception instanceof ARException) {
                ARException aRException = (ARException)((Object)exception);
                List list = aRException.getLastStatus();
                string = EMPTY_STRING;
                if (list != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = list.size();
                    int n2 = 0;
                    for (StatusInfo statusInfo : list) {
                        if (statusInfo != null) {
                            String string2 = statusInfo.getMessageText();
                            String string3 = statusInfo.getAppendedText();
                            stringBuffer.append(string2 != null ? string2 : EMPTY_STRING);
                            stringBuffer.append(string3 != null ? APPENDED_TEXT_SEP + string3 : EMPTY_STRING);
                            int n3 = statusInfo.getMessageType();
                            String string4 = n3 >= 0 && n3 < serverMsgTags.length ? serverMsgTags[n3] : Integer.toString(n3);
                            stringBuffer.append(" (" + string4 + WHITE_SPACE + statusInfo.getMessageNum() + CLOSING_BRACE);
                            if (n2 + 1 < n) {
                                stringBuffer.append(EOL);
                            }
                        }
                        ++n2;
                    }
                    string = stringBuffer.toString();
                }
            } else {
                string = exception.getMessage();
            }
            this.errorLogger.error((Object)string);
        }
    }

    public void logFormattedErrorMessage(Logger logger, int n, Object[] objectArray, String string, Locale locale) {
        this.logFormattedErrorMessage(true, logger, n, objectArray, string, locale);
    }

    public void logFormattedErrorMessage(boolean bl, Logger logger, int n, Object[] objectArray, String string, Locale locale) {
        this.logFormattedErrorMessage(bl, logger, null, n, objectArray, string, locale);
    }

    public void logFormattedErrorMessage(boolean bl, Logger logger, String string, int n, Object[] objectArray, String string2, Locale locale) {
        String string3 = null;
        if (logger == null) {
            string3 = string != null ? this.catalogReader.getMessage(string, n, objectArray, string2, locale) : this.catalogReader.getMessage(n, objectArray, string2, locale);
            System.err.println(EOL + string3);
            return;
        }
        if (bl && logger.isEnabledFor((Priority)Level.ERROR)) {
            string3 = string != null ? this.catalogReader.getMessage(string, n, objectArray, string2, locale) : this.catalogReader.getMessage(n, objectArray, string2, locale);
            string3 = this.logTagger != null ? string3 + WHITE_SPACE + this.logTagger.getTag(n) : n + WHITE_SPACE + string3;
            this.logMessage(logger, Level.ERROR, string3);
        }
        if (this.errorLogger != null) {
            if (string3 == null) {
                string3 = string != null ? this.catalogReader.getMessage(string, n, objectArray, string2, locale) : this.catalogReader.getMessage(n, objectArray, string2, locale);
                string3 = this.logTagger != null ? string3 + WHITE_SPACE + this.logTagger.getTag(n) : n + WHITE_SPACE + string3;
            }
            this.logMessage(this.errorLogger, Level.ERROR, string3);
        }
    }

    public void logFormattedErrorMessage(Logger logger, String string, Object[] objectArray, String string2, Locale locale) {
        this.logFormattedErrorMessage(logger, null, string, objectArray, string2, locale);
    }

    public void logFormattedErrorMessage(Logger logger, String string, String string2, Object[] objectArray, String string3, Locale locale) {
        String string4 = null;
        if (logger == null) {
            string4 = string != null ? this.catalogReader.getMessage(string, string2, objectArray, string3, locale) : this.catalogReader.getMessage(string2, objectArray, string3, locale);
            System.err.println(EOL + string4);
            return;
        }
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            string4 = string != null ? this.catalogReader.getMessage(string, string2, objectArray, string3, locale) : this.catalogReader.getMessage(string2, objectArray, string3, locale);
            this.logMessage(logger, Level.ERROR, string2 + WHITE_SPACE + string4);
        }
        if (this.errorLogger != null) {
            if (string4 == null) {
                string4 = string != null ? this.catalogReader.getMessage(string, string2, objectArray, string3, locale) : this.catalogReader.getMessage(string2, objectArray, string3, locale);
            }
            this.logMessage(this.errorLogger, Level.ERROR, string2 + WHITE_SPACE + string4);
        }
    }
}

