/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;

public class EntryBackedObject {
    public static final int ENTRY_ID_FLDID = 1;
    public static final int TRUE_INT = 1;
    public static final int FALSE_INT = 0;
    private Entry entry;

    public EntryBackedObject() {
    }

    public EntryBackedObject(Entry entry) {
        this.setEntry(entry);
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String getEntryId() {
        Value value = this.getValue(1);
        if (value != null && value.getDataType() == DataType.CHAR) {
            return (String)value.getValue();
        }
        return null;
    }

    public void setValue(int n, Value value) {
        if (this.entry == null) {
            this.entry = new Entry();
        }
        if (this.entry != null) {
            this.entry.put(Integer.valueOf(n), value);
        }
    }

    public Value getValue(int n) {
        Value value = (Value)this.entry.get((Object)n);
        return value;
    }

    public void setInt(int n, int n2) {
        this.setValue(n, new Value(n2));
    }

    public void setEnum(int n, int n2) {
        this.setValue(n, new Value((Object)n2, DataType.ENUM));
    }

    public void setDouble(int n, double d) {
        this.setValue(n, new Value(d));
    }

    public int getInt(int n) {
        Value value = this.getValue(n);
        if (value != null && (value.getDataType() == DataType.INTEGER || value.getDataType() == DataType.ENUM)) {
            return (Integer)value.getValue();
        }
        return -1;
    }

    public double getDouble(int n) {
        Value value = this.getValue(n);
        if (value != null && value.getDataType() == DataType.REAL) {
            return (Double)value.getValue();
        }
        return -1.0;
    }

    public void setString(int n, String string) {
        this.setValue(n, new Value(string));
    }

    public String getString(int n) {
        Value value = this.getValue(n);
        if (value != null && value.getDataType() == DataType.CHAR) {
            return (String)value.getValue();
        }
        return null;
    }

    public void setDate(int n, DateInfo dateInfo) {
        this.setValue(n, new Value(dateInfo));
    }

    public DateInfo getDate(int n) {
        Value value = this.getValue(n);
        if (value != null && value.getDataType() == DataType.DATE) {
            return (DateInfo)value.getValue();
        }
        return null;
    }

    public void setTime(int n, Time time) {
        this.setValue(n, new Value(time));
    }

    public Time getTime(int n) {
        Value value = this.getValue(n);
        if (value != null && value.getDataType() == DataType.TIME_OF_DAY) {
            return (Time)value.getValue();
        }
        return null;
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.setValue(n, new Value(timestamp));
    }

    public Timestamp getTimeStamp(int n) {
        Value value = this.getValue(n);
        if (value != null && value.getDataType() == DataType.TIME) {
            return (Timestamp)value.getValue();
        }
        return null;
    }

    public boolean getBoolean(int n) {
        int n2 = this.getInt(n);
        return n2 == 1;
    }

    protected void setBoolean(int n, boolean bl) {
        if (bl) {
            this.setInt(n, 1);
        } else {
            this.setInt(n, 0);
        }
    }
}

