/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import java.net.InetAddress;

public class CurrentServerInfo {
    private InetAddress localHostAddr = null;
    private String hostShortName = null;
    private String hostFQHN = null;
    private String dnsDomain = null;
    public static final String DOT_SEPERATOR = ".";

    public CurrentServerInfo() {
        try {
            this.localHostAddr = InetAddress.getLocalHost();
            this.hostShortName = this.getCorrectHostShortName(this.localHostAddr.getHostName());
            this.hostFQHN = this.localHostAddr.getCanonicalHostName();
            if (this.hostShortName != null && this.hostFQHN != null && this.hostFQHN.length() > this.hostShortName.length()) {
                this.dnsDomain = this.hostFQHN.substring(this.hostShortName.length());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CurrentServerInfo(String string) {
        try {
            this.localHostAddr = InetAddress.getLocalHost();
            this.hostShortName = this.getCorrectHostShortName(this.localHostAddr.getHostName());
            this.dnsDomain = string != null ? (string.startsWith(DOT_SEPERATOR) ? string : DOT_SEPERATOR + string) : this.localHostAddr.getCanonicalHostName().substring(this.hostShortName.length());
            this.hostFQHN = this.hostShortName + this.dnsDomain;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CurrentServerInfo(String string, String string2) {
        try {
            this.localHostAddr = InetAddress.getLocalHost();
            this.hostShortName = string != null ? string : this.getCorrectHostShortName(this.localHostAddr.getHostName());
            if (string2 != null) {
                this.dnsDomain = string2.startsWith(DOT_SEPERATOR) ? string2 : DOT_SEPERATOR + string2;
            } else {
                String string3 = string != null ? this.getCorrectHostShortName(this.localHostAddr.getHostName()) : this.hostShortName;
                String string4 = this.localHostAddr.getCanonicalHostName();
                if (string4.startsWith(string3)) {
                    this.dnsDomain = string4.substring(string3.length());
                }
            }
            this.hostFQHN = this.dnsDomain != null ? this.hostShortName + this.dnsDomain : this.hostShortName;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHostShortName() {
        return this.hostShortName;
    }

    public String getHostFQHN() {
        return this.hostFQHN;
    }

    public String getDnsDomain() {
        return this.dnsDomain;
    }

    public void setDnsDomain(String string) {
        this.dnsDomain = string;
        if (string != null) {
            this.hostFQHN = this.hostShortName + string;
        }
    }

    private String getCorrectHostShortName(String string) {
        if (string != null && string.contains(DOT_SEPERATOR)) {
            return string.substring(0, string.indexOf(DOT_SEPERATOR));
        }
        return string;
    }
}

