/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.Value;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class UpgradeTracker {
    private String componentName;
    private String componentVersion;
    private StatusType componentStatus;
    private String description;
    private String longDescription;
    private String attachPath;
    private Value startTime;
    private Value endTime;
    private String commandLineArgs;
    private String serverName;
    private String serverConnectName;
    private static final int FLD_REQUEST_ID = 1;
    private static final int FLD_COMPONENT_NAME = 43001;
    private static final int FLD_COMPONENT_STATUS = 43002;
    private static final int FLD_COMPONENT_VERSION = 43003;
    private static final int FLD_COMPONENT_DESCRIPTION = 43004;
    private static final int FLD_COMPONENT_END_TIME = 43005;
    private static final int FLD_COMPONENT_START_TIME = 43006;
    private static final int FLD_COMPONENT_LONG_DESCRIPTION = 43007;
    private static final int FLD_COMPONENT_ATTACHMENT = 43009;
    private static final int FLD_COMPONENT_COMMANDLINE_ARGS = 43010;
    private static final int FLD_SERVER_NAME = 43011;
    private static final int FLD_SERVER_CONNECT_NAME = 43012;
    private final String UPGRADE_TRACKER_FORM = "AR System Upgrade Tracker";
    private final int[] fieldIds = new int[]{1, 43001, 43002, 43003, 43004, 43005, 43006, 43007, 43009, 43011, 43012};

    public UpgradeTracker() {
    }

    public UpgradeTracker(String componentName, Value startTime) {
        this.componentName = componentName;
        this.startTime = startTime;
    }

    public UpgradeTracker(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public StatusType getComponentStatus() {
        return this.componentStatus;
    }

    public void setComponentStatus(StatusType componentStatus) {
        this.componentStatus = componentStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getAttachPath() {
        return this.attachPath;
    }

    public void setAttachPath(String attachPath) {
        this.attachPath = attachPath;
    }

    public Value getStartTime() {
        return this.startTime;
    }

    private void setStartTime(ARServerUser serverUser) throws ARException {
        Value startTime;
        this.startTime = startTime = this.getServerTime(serverUser);
    }

    public void setStartTime(Value startTime) {
        this.startTime = startTime;
    }

    public Value getEndTime() {
        return this.endTime;
    }

    private void setEndTime(ARServerUser serverUser) throws ARException {
        Value endTime;
        this.endTime = endTime = this.getServerTime(serverUser);
    }

    public void setEndTime(Value endTime) {
        this.startTime = endTime;
    }

    public String getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public void setCommandLineArgs(String commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerConnectName() {
        return this.serverConnectName;
    }

    public void setServerConnectName(String serverConnectName) {
        this.serverConnectName = serverConnectName;
    }

    public String creatEntry(ARServerUser user) throws IOException, ARException {
        String entryId = "";
        this.setStartTime(user);
        Entry entry = this.createUpgradeEntryObject(user);
        entryId = user.createEntry("AR System Upgrade Tracker", entry);
        return entryId;
    }

    public List<Entry> readEntryList(ARServerUser user, String componentName) throws ARException {
        ArrayList<Entry> entryList = new ArrayList();
        RelationalOperationInfo relopInfo = new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(43001), new ArithmeticOrRelationalOperand(new Value(componentName)));
        QualifierInfo qual = new QualifierInfo(relopInfo);
        entryList = user.getListEntryObjects("AR System Upgrade Tracker", qual, 0, 0, null, this.fieldIds, false, null);
        return entryList;
    }

    public boolean updateLongDescriptionByEntryId(ARServerUser user, String entryId, String longDescription) throws ARException {
        if (entryId == null || longDescription == null) {
            return false;
        }
        List entryList = new ArrayList();
        RelationalOperationInfo relopInfo = new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(1), new ArithmeticOrRelationalOperand(new Value(entryId)));
        QualifierInfo qual = new QualifierInfo(relopInfo);
        entryList = user.getListEntryObjects("AR System Upgrade Tracker", qual, 0, 0, null, this.fieldIds, false, null);
        if (entryList.size() > 0) {
            Entry entry = (Entry)entryList.get(0);
            Value currentLongDesc = (Value)entry.get((Object)43007);
            String currentLongDescStr = currentLongDesc.toString();
            String newLongDesc = currentLongDescStr != null ? currentLongDescStr + longDescription : longDescription;
            entry.put(Integer.valueOf(43007), new Value(newLongDesc));
            user.setEntry("AR System Upgrade Tracker", entryId, entry, null, 0);
            return true;
        }
        return false;
    }

    public boolean updateEntry(ARServerUser user, String entryId, boolean isExecutionComplete) throws ARException, IOException {
        Entry entry = new Entry();
        if (isExecutionComplete) {
            this.setEndTime(user);
        }
        entry = this.createUpgradeEntryObject(user);
        user.setEntry("AR System Upgrade Tracker", entryId, entry, null, 0);
        return true;
    }

    public boolean updateEntry(ARServerUser user, String entryId) throws ARException, IOException {
        Entry entry = new Entry();
        entry = this.createUpgradeEntryObject(user);
        user.setEntry("AR System Upgrade Tracker", entryId, entry, null, 0);
        return true;
    }

    private Entry createUpgradeEntryObject(ARServerUser user) throws IOException {
        Entry entry = new Entry();
        this.serverName = user.getServer();
        entry.put(Integer.valueOf(43001), new Value(this.componentName));
        entry.put(Integer.valueOf(43002), new Value(this.componentStatus.getStatus()));
        entry.put(Integer.valueOf(43003), new Value(this.componentVersion));
        entry.put(Integer.valueOf(43004), new Value(this.description));
        entry.put(Integer.valueOf(43005), this.endTime);
        entry.put(Integer.valueOf(43006), this.startTime);
        entry.put(Integer.valueOf(43007), new Value(this.longDescription));
        entry.put(Integer.valueOf(43011), new Value(this.serverName));
        entry.put(Integer.valueOf(43012), new Value(this.serverConnectName));
        if (this.attachPath != null) {
            entry.put(Integer.valueOf(43009), new Value(new AttachmentValue(this.attachPath)));
        }
        if (this.commandLineArgs != null && !this.commandLineArgs.isEmpty()) {
            entry.put(Integer.valueOf(43010), new Value(this.commandLineArgs));
        }
        return entry;
    }

    private Value getServerTime(ARServerUser serverUser) throws ARException {
        ServerInfoMap svrMap;
        Value serverTime = null;
        int[] mapId = new int[]{116};
        if (serverUser != null && (svrMap = serverUser.getServerInfo(mapId)) != null) {
            serverTime = (Value)svrMap.get((Object)116);
        }
        return serverTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLogFileToLongDescription(String logFileName) throws IOException {
        File logFile = new File(logFileName);
        StringBuffer log = new StringBuffer();
        if (logFile.exists()) {
            FileInputStream fileReader = new FileInputStream(logFile);
            InputStreamReader inputStreamReader = new InputStreamReader(new DataInputStream(fileReader));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                char[] buffer = new char[(int)logFile.length()];
                bufferedReader.read(buffer, 0, (int)logFile.length());
                log.append(buffer);
            }
            finally {
                bufferedReader.close();
                inputStreamReader.close();
                fileReader.close();
            }
            this.setLongDescription(log.toString());
        }
    }

    public static enum StatusType {
        PASSED("PASSED"),
        FAILED("FAILED"),
        STARTED("STARTED"),
        CANCELLED("CANCELLED");

        private String status;

        private StatusType(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

