/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefinitionOptions {
    private static Logger logger = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private ARServerUser context;
    private String user = "";
    private String password = "";
    private String server = "";
    private String authentication = "";
    private int portNumber = 0;
    private final Map<DefinitionItemType, Boolean> allFlags = new HashMap<DefinitionItemType, Boolean>();
    private final Map<DefinitionItemType, List<BaseItemData>> items = new HashMap<DefinitionItemType, List<BaseItemData>>();
    private final Map<String, List<String>> elements = new HashMap<String, List<String>>();
    private Operation operation = Operation.NONE;
    private String fileName = "";
    private String commandSetFile = null;
    private boolean overwrite = false;
    int exportOption = 0;
    private boolean deleteExcessFields = false;
    private boolean deleteExcessViews = false;
    private int lockType = 0;
    private boolean serverIndependent = true;
    private boolean importCompleteFile = false;
    private String lockKey = "";
    private int conflictHandling = 16;
    private boolean preserveIndex = false;
    private boolean preserveVUINamespace = false;
    private boolean preserveAppForms = false;
    private boolean importWithAppOwner = false;
    private boolean overwriteFullTextOptions = false;
    private boolean overwriteDisplayProperties = false;
    private String logFile = null;
    private boolean dsoLicensed = false;
    private String charset = null;
    private String serverLanguage = null;
    private int clientType = 36;
    private String taskName;
    private String labelName;
    private String taskDescription;
    private String labelDescription;
    private String overlayGroup;

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getLabelDescription() {
        return this.labelDescription;
    }

    public void setLabelDescription(String labelDescription) {
        this.labelDescription = labelDescription;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getServerLanguage() {
        return this.serverLanguage;
    }

    public void setServerLanguage(String serverLanguage) {
        this.serverLanguage = serverLanguage;
    }

    public boolean isDsoLicensed() {
        return this.dsoLicensed;
    }

    public void setDsoLicensed(boolean dsoLicensed) {
        this.dsoLicensed = dsoLicensed;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    public int getLockType() {
        return this.lockType;
    }

    public void setLockType(int lockType) {
        this.lockType = lockType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isAll(DefinitionItemType type) {
        if (this.allFlags.get((Object)type) != null) {
            return this.allFlags.get((Object)type);
        }
        return false;
    }

    public void setAll(DefinitionItemType type, boolean all) {
        this.allFlags.put(type, all);
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getOverlayGroup() {
        return this.overlayGroup;
    }

    public void setOverlayGroup(String overlayGroup) {
        this.overlayGroup = overlayGroup;
    }

    public void add(DefinitionItemType type, String name, RelatedType related) {
        if (name != null && name.length() > 0) {
            if (this.items.get((Object)type) == null) {
                this.items.put(type, new ArrayList());
            }
            this.items.get((Object)type).add(new DefinitionItemData(type, name, related));
        }
    }

    public void addElement(String name, String application) {
        if (name != null && name.length() > 0) {
            if (this.elements.get(application) == null) {
                this.elements.put(application, new ArrayList());
            }
            this.elements.get(application).add(name);
        }
    }

    public void add(BaseItemData data) {
        if (data != null) {
            if (this.items.get((Object)data.getType()) == null) {
                this.items.put(data.getType(), new ArrayList());
            }
            this.items.get((Object)data.getType()).add(data);
        }
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getExportOption() {
        return this.exportOption;
    }

    public void setExportOption(int exportOption) {
        this.exportOption = exportOption;
    }

    public String getCommandSetFile() {
        return this.commandSetFile;
    }

    public void setCommandSetFile(String commandSetFile) {
        this.commandSetFile = commandSetFile;
    }

    public void validate() throws DefinitionException {
        if (this.getUser() == null || this.getUser() != null && this.getUser().length() == 0) {
            throw new DefinitionException("User Name must be provided");
        }
        if (this.getServer() == null || this.getServer() != null && this.getServer().length() == 0) {
            throw new DefinitionException("Server Name must be provided");
        }
        if (this.getFileName() == null || this.getFileName() != null && this.getFileName().length() == 0) {
            throw new DefinitionException("File Name must be provided");
        }
        int validateFileName = Util.validateFileName(this.getFileName());
        switch (validateFileName) {
            case 1: {
                throw new DefinitionException("File name validation failed. The directory is not valid.");
            }
            case 2: {
                throw new DefinitionException("File name validation failed. The file name is invalid.");
            }
            case 3: {
                throw new DefinitionException("File name validation failed. No file name was supplied.");
            }
            case 4: {
                throw new DefinitionException("File name validation failed. The supplied file name is a directory.");
            }
            case 5: {
                throw new DefinitionException("File name validation failed. The directory does not exist.");
            }
            case 6: {
                throw new DefinitionException("File name validation failed. The file name must have a .def or .xml extension.");
            }
        }
        if (validateFileName != 0) {
            // empty if block
        }
    }

    public boolean requiresExpansion() {
        for (DefinitionItemType type : this.allFlags.keySet()) {
            if (this.allFlags.get((Object)type) == null || !this.allFlags.get((Object)type).booleanValue()) continue;
            return true;
        }
        for (DefinitionItemType key : this.items.keySet()) {
            List<BaseItemData> itemList = this.items.get((Object)key);
            if (itemList == null) continue;
            for (BaseItemData data : itemList) {
                if (!(data instanceof DefinitionItemData) || ((DefinitionItemData)data).getRelated() == RelatedType.NONE || ((DefinitionItemData)data).getRelated() == RelatedType.FULL) continue;
                return true;
            }
        }
        return false;
    }

    public void connect() throws ARException {
        try {
            this.context = new ARServerUser();
            this.context.setUser(this.getUser());
            this.context.setPassword(this.getPassword());
            this.context.setServer(this.getServer());
            this.context.setPort(this.getPortNumber());
            this.context.setAuthentication(this.getAuthentication());
            this.context.setClientType(this.clientType);
            this.context.useAdminRpcQueue();
            this.context.setOverlayGroup(this.getOverlayGroup());
            this.context.login();
        }
        catch (ARException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)MessageFormat.format("Unable to connect to server {0} : {1}", this.getServer(), e.getMessage()));
            }
            throw e;
        }
    }

    public ARServerUser getContext() {
        return this.context;
    }

    public boolean isXML() {
        return this.fileName != null && this.fileName.length() > 0 && this.fileName.toUpperCase().endsWith(".XML");
    }

    public int getObjectCount() {
        int result = 0;
        for (DefinitionItemType type : this.items.keySet()) {
            if (this.items.get((Object)type) == null) continue;
            result += this.items.get((Object)type).size();
        }
        return result;
    }

    public List<BaseItemData> getItems(DefinitionItemType type) {
        return this.items.get((Object)type);
    }

    public List<String> getElements(String application) {
        return this.elements.get(application);
    }

    public boolean hasElements(String application) {
        return this.elements.get(application) != null;
    }

    public String getLastName(DefinitionItemType type) {
        if (this.items.get((Object)type).size() == 0) {
            return new String();
        }
        return this.items.get((Object)type).get(this.items.get((Object)type).size() - 1).getName();
    }

    public void addAll(Map<DefinitionItemType, List<BaseItemData>> itemMap) {
        for (DefinitionItemType key : itemMap.keySet()) {
            List<BaseItemData> itemList = itemMap.get((Object)key);
            if (itemList == null) continue;
            if (this.items.get((Object)key) == null) {
                this.items.put(key, itemList);
                continue;
            }
            for (BaseItemData data : itemList) {
                this.items.get((Object)key).add(data);
            }
        }
    }

    public Map<DefinitionItemType, Boolean> getAllFlags() {
        return this.allFlags;
    }

    public boolean isServerIndependent() {
        return this.serverIndependent;
    }

    public void setServerIndependent(boolean serverIndependent) {
        this.serverIndependent = serverIndependent;
    }

    public Map<DefinitionItemType, List<BaseItemData>> getItems() {
        return this.items;
    }

    public boolean isDeleteExcessFields() {
        return this.deleteExcessFields;
    }

    public void setDeleteExcessFields(boolean deleteExcessFields) {
        this.deleteExcessFields = deleteExcessFields;
    }

    public boolean isDeleteExcessViews() {
        return this.deleteExcessViews;
    }

    public void setDeleteExcessViews(boolean deleteExcessViews) {
        this.deleteExcessViews = deleteExcessViews;
    }

    public int getConflictHandling() {
        return this.conflictHandling;
    }

    public void setConflictHandling(int conflictHandling) {
        this.conflictHandling = conflictHandling;
    }

    public boolean isImportCompleteFile() {
        return this.importCompleteFile;
    }

    public void setImportCompleteFile(boolean importCompleteFile) {
        this.importCompleteFile = importCompleteFile;
    }

    public boolean isPreserveVUINamespace() {
        return this.preserveVUINamespace;
    }

    public void setPreserveVUINamespace(boolean preserveVUINamespace) {
        this.preserveVUINamespace = preserveVUINamespace;
    }

    public boolean isPreserveIndex() {
        return this.preserveIndex;
    }

    public void setPreserveIndex(boolean preserveIndex) {
        this.preserveIndex = preserveIndex;
    }

    public boolean isPreserveAppForms() {
        return this.preserveAppForms;
    }

    public void setPreserveAppForms(boolean preserveAppForms) {
        this.preserveAppForms = preserveAppForms;
    }

    public boolean isImportWithAppOwner() {
        return this.importWithAppOwner;
    }

    public void setImportWithAppOwner(boolean importWithAppOwner) {
        this.importWithAppOwner = importWithAppOwner;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public boolean isOverwriteFullTextOptions() {
        return this.overwriteFullTextOptions;
    }

    public void setOverwriteFullTextOptions(boolean overwrite) {
        this.overwriteFullTextOptions = overwrite;
    }

    public boolean isOverwriteDisplayProperties() {
        return this.overwriteDisplayProperties;
    }

    public void setOverwriteDisplayProperties(boolean overwrite) {
        this.overwriteDisplayProperties = overwrite;
    }

    public static enum Operation {
        NONE,
        IMPORT,
        EXPORT;

    }
}

