/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.ascii;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ASCIIParser
extends Parser {
    protected String separator = ",";
    protected boolean hasTitles = false;

    public ASCIIParser(String separator, boolean hasTitles) {
        this.hasTitles = hasTitles;
        this.separator = separator;
    }

    protected List<String> parseLine(String line, int lineNumber) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        if (line == null) {
            line = "";
        }
        for (int counter = 0; counter <= line.length(); counter += this.separator.length()) {
            buffer.setLength(0);
            counter = this.handlePlainField(line, buffer, counter);
            if (counter > line.length()) continue;
            result.add(buffer.toString());
        }
        return result;
    }

    private int handlePlainField(String token, StringBuffer buffer, int index) {
        int position = token.indexOf(this.separator, index);
        if (position == -1) {
            if (index > 0 && token.charAt(index - 1) == this.separator.charAt(0) || index == 0 && token.substring(index).length() != 0) {
                buffer.append(token.substring(index));
                return token.length();
            }
            return token.length() + 1;
        }
        buffer.append(token.substring(index, position));
        return position;
    }

    public BufferedReader openFile(String fileName, String charSet) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        InputStreamReader streamReader = null;
        streamReader = charSet != null && charSet.length() > 0 ? new InputStreamReader((InputStream)inStream, charSet) : new InputStreamReader(inStream);
        BufferedReader fileReader = new BufferedReader(streamReader);
        return fileReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String fileName, String charSet) throws IOException, ARImportException, ARException {
        try (BufferedReader fileReader = null;){
            fileReader = this.openFile(fileName, charSet);
            int lineNumber = 0;
            String line = null;
            while ((line = fileReader.readLine()) != null && !this.isAbort() && !this.isCopyToLog()) {
                ++lineNumber;
                if (this.isAbort() && this.isCopyToLog()) {
                    this.fireEvent(new ParseEvent(1, null, line));
                    continue;
                }
                List<String> dataTokens = this.parseLine(line, lineNumber);
                if (lineNumber == 1 && this.isHasTitles()) {
                    this.fireEvent(new ParseEvent(3, dataTokens, line));
                    continue;
                }
                if (dataTokens.size() <= 0) continue;
                this.fireEvent(new ParseEvent(1, dataTokens, line));
            }
            this.fireEvent(new ParseEvent(2));
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isHasTitles() {
        return this.hasTitles;
    }

    public void setHasTitles(boolean hasTitles) {
        this.hasTitles = hasTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> extractFirstLine(String fileName, String separator, String charSet) throws IOException, ARImportException {
        this.separator = separator;
        List<String> result = null;
        try (BufferedReader reader = null;){
            reader = this.openFile(fileName, charSet);
            String line = reader.readLine();
            List<String> list = result = this.parseLine(line, 0);
            return list;
        }
    }
}

