/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public final class Util {
    private static final Util instance = new Util();
    private static final String FIELD_TITLE = "Field ";
    public static final String ARIMPORT_FILE_APPENDER = "ARIMPORT_FILE_APPENDER";
    private static final PatternLayout entryLayout = new PatternLayout("%m%n");
    private FileAppender fileAppender = null;
    public static final String dot = ".";

    private Util() {
    }

    public static int countDelimeters(String value, String strDelimeter) {
        int iLength = strDelimeter.length();
        int iResult = 0;
        int start = value.indexOf(strDelimeter);
        while (start != -1) {
            ++iResult;
            start = value.indexOf(strDelimeter, start + iLength);
        }
        return iResult;
    }

    public static long secondsSinceMidnight(Calendar cal) {
        Calendar localCal = cal;
        if (localCal == null) {
            localCal = Calendar.getInstance();
            localCal.setTime(new Date());
        }
        return localCal.get(39600) + localCal.get(720) + localCal.get(13);
    }

    public static MappingOptions generateMappingsForARX(FormInformation targetForm, FormInformation sourceForm) {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions result = new MappingOptions();
        logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        for (FieldInformation fieldInfo : targetForm.getFields().values()) {
            if (fieldInfo.getDataType() == null) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(fieldInfo.getFieldId());
            mapping.setFieldName(fieldInfo.getName());
            FieldInformation sourceField = sourceForm.getFields().get(fieldInfo.getFieldId());
            if (sourceField == null || !fieldInfo.getDataType().equals((Object)sourceField.getDataType())) continue;
            mapping.setTokenIndex(sourceField.getTokenIndex());
            result.addMapping(fieldInfo.getFieldId(), mapping);
        }
        return result;
    }

    public static MappingOptions generateMappingsForTextFiles(FormInformation targetForm, List<String> tokens, boolean isTitles) {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions result = new MappingOptions();
        logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        for (FieldInformation field : targetForm.getFields().values()) {
            int index;
            if (field.getFieldId() == 15 || (index = tokens.indexOf(field.getName())) == -1) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(index);
            mapping.setTokenIndex(index);
            if (isTitles) {
                mapping.setFieldName(tokens.get(index));
            } else {
                mapping.setFieldName(FIELD_TITLE + index);
            }
            result.addMapping(field.getFieldId(), mapping);
        }
        return result;
    }

    public static MappingOptions generateMappingsForTextFiles(FormInformation targetForm, FormInformation sourceForm) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions result = new MappingOptions();
        logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        if (targetForm == null) {
            throw new ARImportException(ImportErrors.ERROR_NO_TARGET_FORM.toDefMsg());
        }
        for (FieldInformation targetField : targetForm.getFields().values()) {
            int index;
            if (targetField.getFieldId() == 15) continue;
            FieldInformation sourceField = null;
            for (FieldInformation fieldInfo : sourceForm.getFields().values()) {
                if (!targetField.getName().equals(fieldInfo.getName())) continue;
                sourceField = fieldInfo;
                break;
            }
            if (sourceField == null || (index = sourceField.getTokenIndex()) == -1) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(index);
            mapping.setTokenIndex(index);
            mapping.setFieldName(sourceField.getName());
            result.addMapping(targetField.getFieldId(), mapping);
        }
        return result;
    }

    public static Util getInstance() {
        return instance;
    }

    public static FormInformation getServerForm(ImportOptions options, String formName) throws ARException {
        FormInformation result = new FormInformation();
        List fields = options.getContext().getListFieldObjects(formName, 1);
        if (fields != null) {
            for (Field field : fields) {
                FieldInformation fieldInfo = new FieldInformation();
                fieldInfo.setFieldId(field.getFieldID());
                fieldInfo.setDataType(DataType.toDataType((int)field.getDataType()));
                fieldInfo.setDefaultValue(field.getDefaultValue());
                fieldInfo.setLimit(field.getFieldLimit());
                fieldInfo.setName(field.getName());
                fieldInfo.setFieldOption(field.getFieldOption());
                result.getFields().put(fieldInfo.getFieldId(), fieldInfo);
            }
        }
        result.setName(formName);
        result.setServer(options.getContext().getServer());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findMappingFile(String mappingDir, String mappingName, String charSet) throws IOException {
        String result = null;
        if (mappingDir == null || mappingDir.length() == 0) {
            mappingDir = new File(dot).getCanonicalPath();
        }
        File dir = new File(mappingDir);
        String[] children = dir.list();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".ARM");
            }
        };
        children = dir.list(filter);
        if (children == null) {
            throw new IOException(ImportErrors.IO_ERROR_ON_MAPPING_DIR_RETRIEVE.toDefMsg() + mappingDir);
        }
        for (String fileName : children) {
            try (FileInputStream inStream = null;){
                inStream = new FileInputStream(dir.getCanonicalPath() + System.getProperty("file.separator") + fileName);
                InputStreamReader streamReader = null;
                streamReader = charSet != null && charSet.length() > 0 ? new InputStreamReader((InputStream)inStream, charSet) : new InputStreamReader(inStream);
                BufferedReader fileReader = new BufferedReader(streamReader);
                String line = fileReader.readLine();
                if (line != null && line.equals(mappingName)) {
                    result = fileName;
                }
                fileReader.close();
            }
        }
        return mappingDir + "/" + result;
    }

    public static void logEntry(String line) {
        Logger logger = ThreadLocalStorage.getLogger();
        if (Util.getInstance().getFileAppender() != null) {
            Layout oldLayout = Util.getInstance().getFileAppender().getLayout();
            Util.getInstance().getFileAppender().setLayout((Layout)entryLayout);
            logger.info((Object)line);
            Util.getInstance().getFileAppender().setLayout(oldLayout);
        }
    }

    public void setFileAppender(FileAppender fileAppender) {
        this.fileAppender = fileAppender;
    }

    public FileAppender getFileAppender() {
        return this.fileAppender;
    }
}

