/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class JIThreadPoolExecutor {
    private ThreadPoolExecutor threadPool;
    private LinkedBlockingQueue<Runnable> jobQueue;
    private static JIThreadPoolExecutor threadPoolExecutor = null;
    private Logger logger = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
    private List<Future<ImportOptions>> future;

    public List<Future<ImportOptions>> getFuture() {
        return this.future;
    }

    public void setFuture(List<Future<ImportOptions>> future) {
        this.future = future;
    }

    public void deleteFuture() {
        this.future.clear();
        this.logger.debug((Object)ImportErrors.DELETE_FUTURE_OBJECTS.toDefMsg());
    }

    private JIThreadPoolExecutor() {
        this.jobQueue = new LinkedBlockingQueue();
        this.future = new LinkedList<Future<ImportOptions>>();
    }

    public void createPool(int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this.threadPool = new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, this.jobQueue);
        this.threadPool.prestartAllCoreThreads();
        this.logger.debug((Object)MessageFormat.format(ImportErrors.CREATING_THREADPOOL.toDefMsg(), maximumPoolSize));
    }

    public void deletePool() {
        this.threadPool.shutdownNow();
        this.jobQueue.clear();
        this.threadPool = null;
        this.logger.debug((Object)ImportErrors.DELETE_THREADPOOL.toDefMsg());
    }

    public static synchronized JIThreadPoolExecutor getInstance() {
        if (threadPoolExecutor == null) {
            threadPoolExecutor = new JIThreadPoolExecutor();
        }
        return threadPoolExecutor;
    }

    public boolean stop() {
        this.logger.debug((Object)ImportErrors.STOP_THREADPOOL.toDefMsg());
        if (this.threadPool != null) {
            this.threadPool.shutdown();
            return true;
        }
        return false;
    }

    public void addTask(Runnable task) {
        Future<?> returnFuture = this.threadPool.submit(task);
        this.future.add(returnFuture);
        this.logger.debug((Object)ImportErrors.ADD_TASK.toDefMsg());
    }

    public void addMultipleTask(List<Callable<ImportOptions>> tasks) {
        for (Callable<ImportOptions> runnable : tasks) {
            Future<ImportOptions> returnFuture = this.threadPool.submit(runnable);
            this.future.add(returnFuture);
        }
        this.logger.debug((Object)MessageFormat.format(ImportErrors.ADD_MULTIPLE_TASK.toDefMsg(), tasks.size()));
    }

    public boolean join() {
        try {
            this.logger.debug((Object)ImportErrors.JOIN_THREADS_IN_POOL.toDefMsg());
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            this.logger.debug((Object)MessageFormat.format(ImportErrors.JOIN_THREADS_COMPLETED.toDefMsg(), "successfully"));
            return true;
        }
        catch (InterruptedException e) {
            this.logger.debug((Object)MessageFormat.format(ImportErrors.JOIN_THREADS_COMPLETED.toDefMsg(), "with Error"));
            return false;
        }
    }
}

