/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.KeywordExpander;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class EntryFactory
extends BaseObject {
    private ImportOptions options = null;
    private FormInformation sourceForm = null;
    private FormInformation targetForm = null;
    private Converter converter = null;
    private KeywordExpander expander = null;
    private IParser parser = null;
    public static final String dollar = "$";
    public static final char currencySeparator = '\u0004';

    public EntryFactory(IParser parser, ImportOptions options, String sourceFormName, String targetFormName, Converter converter, KeywordExpander expander) throws ARImportException {
        this.parser = parser;
        this.options = options;
        this.sourceForm = options.getFileForms().get(sourceFormName);
        this.targetForm = options.getServerForms().get(targetFormName);
        if (this.sourceForm == null || this.targetForm == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.converter = converter;
        this.expander = expander;
    }

    public EntryFactory(IParser parser, ImportOptions options, String sourceFormName, String targetFormName) throws ARImportException {
        this(parser, options, targetFormName, targetFormName, new Converter(options), new KeywordExpander(options));
    }

    public EntryFactory(IParser parser, ImportOptions options, FormInformation sourceForm, FormInformation targetForm) throws ARImportException {
        this.parser = parser;
        this.options = options;
        this.sourceForm = sourceForm;
        this.targetForm = targetForm;
        if (sourceForm == null || targetForm == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.converter = new Converter(options);
        this.expander = new KeywordExpander(options);
    }

    public ImportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ImportOptions options) {
        this.options = options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry createEntry(List<String> tokens, String line) throws ARImportException, NullPointerException, ARException, Exception {
        String message;
        Logger logger = ThreadLocalStorage.getLogger();
        Entry result = new Entry();
        int isSuppressDefaults = this.options.getDataOptions().getSuppressDefaults();
        MappingOptions maps = this.options.getMappingOptions(this.sourceForm.getName(), this.targetForm.getName());
        if (maps == null) {
            maps = this.options.getMappingOptions("ARImport_Data_Holder", this.targetForm.getName());
        }
        if (maps == null) {
            throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CREATE_ENTRY.toDefMsg(), tokens));
        }
        this.applyMappings(maps, this.sourceForm, this.targetForm, tokens);
        for (Integer key : maps.getMappings().keySet()) {
            Value value;
            FieldInformation targetFieldInfo;
            try {
                Mapping mapping = maps.getMappings().get(key);
                targetFieldInfo = this.targetForm.getFields().get(key);
                if (targetFieldInfo == null || targetFieldInfo.getDataType() == null) continue;
                if (mapping.getType() == Mapping.Type.CONSTANT) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_CONSTANT.toDefMsg(), String.valueOf(targetFieldInfo.getFieldId()), mapping));
                    }
                    result.put(Integer.valueOf(targetFieldInfo.getFieldId()), new Value(mapping.getConstant()));
                    continue;
                }
                if (mapping.getType() == Mapping.Type.COMPOUND) {
                    Value value2 = this.converter.convertToARValue(targetFieldInfo, mapping.getCompoundValue());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(targetFieldInfo.getFieldId()), value2, mapping));
                    }
                    result.put(Integer.valueOf(targetFieldInfo.getFieldId()), value2);
                    continue;
                }
                if (mapping.getType() == Mapping.Type.KEYWORD) {
                    Value value3 = this.converter.getKeywordValue(targetFieldInfo, mapping);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(targetFieldInfo.getFieldId()), value3, mapping));
                    }
                    result.put(Integer.valueOf(targetFieldInfo.getFieldId()), value3);
                    continue;
                }
                int index = mapping.getTokenIndex();
                if (index <= -1 || index > tokens.size() - 1) continue;
                String token = tokens.get(index);
                value = this.converter.convertToARValue(targetFieldInfo, token);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(targetFieldInfo.getFieldId()), value, mapping));
                }
                result.put(Integer.valueOf(targetFieldInfo.getFieldId()), value);
            }
            catch (Exception e) {
                targetFieldInfo = this.targetForm.getFields().get(key);
                int field_id = targetFieldInfo.getFieldId();
                this.applyFallbackMappings(maps, this.sourceForm, this.targetForm, tokens, field_id);
                if (!maps.getFallbacks().keySet().contains(field_id)) {
                    throw e;
                }
                Mapping mapping = maps.getFallbacks().get(field_id);
                if (mapping == null) continue;
                if (mapping.getType() == Mapping.Type.CONSTANT) {
                    result.put(Integer.valueOf(field_id), new Value(mapping.getConstant()));
                    continue;
                }
                if (mapping.getType() == Mapping.Type.COMPOUND) {
                    value = this.converter.convertToARValue(targetFieldInfo, mapping.getCompoundValue());
                    result.put(Integer.valueOf(field_id), value);
                    continue;
                }
                if (mapping.getType() == Mapping.Type.KEYWORD) {
                    value = this.converter.getKeywordValue(targetFieldInfo, mapping);
                    result.put(Integer.valueOf(field_id), value);
                    continue;
                }
                int index = mapping.getTokenIndex();
                if (index <= -1 || index > tokens.size() - 1) continue;
                String token = tokens.get(index);
                Value value4 = this.converter.convertToARValue(targetFieldInfo, token);
                result.put(Integer.valueOf(field_id), value4);
            }
        }
        if (!(isSuppressDefaults != 2 && isSuppressDefaults != 3 || this.options.getDataOptions().getDuplicateIdHandling().equals((Object)DataOptions.DuplicateHandling.DUP_MERGE))) {
            Collection<FieldInformation> totalFieldsMap = this.targetForm.getFields().values();
            Set mappedFields = result.keySet();
            Iterator<FieldInformation> e = totalFieldsMap.iterator();
            while (e.hasNext()) {
                FieldInformation fieldInfo = e.next();
                if (fieldInfo.getDefaultValue().getValue() == null || mappedFields.contains(fieldInfo.getFieldId())) continue;
                result.put(Integer.valueOf(fieldInfo.getFieldId()), new Value());
            }
        }
        if (result.isEmpty()) {
            if (this.options.getDataOptions().getBadRecordHandling().equals((Object)DataOptions.BadRecords.SKIP)) {
                logger.info((Object)MessageFormat.format(ImportErrors.UNABLE_TO_DETERMINE_FIELD_VALUE_FOR_RECORD.toDefMsg(), tokens.size(), this.targetForm.getFields().size(), System.getProperty("line.separator"), line));
            }
        } else if (this.targetForm.getFormType() == 1 && this.options.getDataOptions().isDisableRequired()) {
            for (Integer targetFieldId : this.getTargetForm().getFields().keySet()) {
                FieldInformation targetField;
                if (targetFieldId <= 8 || result.containsKey((Object)targetFieldId) || (targetField = this.getTargetForm().getFields().get(targetFieldId)) == null || targetField.getFieldOption() != 1 || this.options.getDataOptions().getDuplicateIdHandling().getMergeOption() == 4 || targetField.getDefaultValue().getValue() != null) continue;
                result.put(targetFieldId, new Value());
            }
        }
        if (this.options.getFileForms().get(this.sourceForm.getName()).getFields().size() > tokens.size()) {
            if (!this.options.getDataOptions().isAllowTooFew()) {
                message = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS.toDefMsg(), tokens.size(), this.options.getFileForms().get(this.sourceForm.getName()).getFields().size());
                if (this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.ALERTUSER) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                    this.getOptions().getResults().addError(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
                    return null;
                }
                if (this.options.getUserAlertListener() != null) {
                    int userChoice = this.options.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), line, message);
                    switch (userChoice) {
                        case 0: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                            if (this.getParser() == null) break;
                            this.getParser().setAbort(true);
                            break;
                        }
                        case 2: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                            if (this.getParser() == null) break;
                            this.getParser().setAbort(true);
                            this.getParser().setCopyToLog(true);
                            break;
                        }
                        default: {
                            logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                        }
                    }
                    this.getOptions().getResults().addError(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
                    return null;
                }
            } else {
                message = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS_FOUND.toDefMsg(), tokens.size(), this.options.getFileForms().get(this.sourceForm.getName()).getFields().size(), System.getProperty("line.separator"), line);
                logger.warn((Object)message);
                this.getOptions().getResults().addWarning(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
            }
        } else if (this.options.getFileForms().get(this.sourceForm.getName()).getFields().size() < tokens.size()) {
            if (!this.options.getDataOptions().isAllowTooMany()) {
                message = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS.toDefMsg(), tokens.size(), this.options.getFileForms().get(this.sourceForm.getName()).getFields().size());
                if (this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.ALERTUSER) {
                    logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                    this.getOptions().getResults().addError(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
                    return null;
                }
                if (this.options.getUserAlertListener() != null) {
                    int userChoice = this.options.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), line, message);
                    switch (userChoice) {
                        case 0: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                            if (this.getParser() == null) break;
                            this.getParser().setAbort(true);
                            break;
                        }
                        case 2: {
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                            logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                            if (this.getParser() == null) break;
                            this.getParser().setAbort(true);
                            this.getParser().setCopyToLog(true);
                            break;
                        }
                        default: {
                            logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), message, System.getProperty("line.separator"), line));
                        }
                    }
                    this.getOptions().getResults().addError(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
                    return null;
                }
            } else {
                message = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS_FOUND.toDefMsg(), tokens.size(), this.options.getFileForms().get(this.sourceForm.getName()).getFields().size(), System.getProperty("line.separator"), line);
                logger.warn((Object)message);
                this.getOptions().getResults().addWarning(this.targetForm.getName(), new RecordResult(this.sourceForm.getName(), this.targetForm.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.targetForm.getName()), message, null));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.NEW_ENTRY.toDefMsg(), result));
        }
        return result;
    }

    public void applyMappings(MappingOptions maps, FormInformation sourceForm, FormInformation targetForm, List<String> tokens) throws ARException {
        int isSuppressDefaults = this.options.getDataOptions().getSuppressDefaults();
        for (Integer key : maps.getMappings().keySet()) {
            Mapping mapping = maps.getMappings().get(key);
            FieldInformation targetField = targetForm.getFields().get(key);
            if (mapping.getType() == Mapping.Type.COMPOUND) {
                String buffer = this.expander.expandAllKeywords(mapping.getCompound(), targetForm, targetField);
                if (buffer != null) {
                    buffer = this.expandFieldValues(buffer, sourceForm, targetForm, tokens);
                }
                mapping.setCompoundValue(buffer);
                continue;
            }
            int index = mapping.getTokenIndex();
            if (index <= -1 || index > tokens.size() - 1) continue;
            String token = tokens.get(index);
            if (isSuppressDefaults != 0 && isSuppressDefaults != 3 || token != null && token.length() != 0 || targetField == null || targetField.getDefaultValue() == null || targetField.getDefaultValue().getDataType().equals((Object)DataType.NULL)) continue;
            token = targetField.getDataType() == DataType.CURRENCY ? this.convertToARXFormat(targetField.getDefaultValue()) : targetField.getDefaultValue().getValue().toString();
            token = this.expander.expandAllKeywords(token, targetForm, targetField);
            tokens.set(index, token);
        }
    }

    private String convertToARXFormat(Value currencyVal) {
        CurrencyValue currVal = (CurrencyValue)currencyVal.getValue();
        String str = currVal.getValueString() + Character.toString('\u0004') + currVal.getCurrencyCode() + Character.toString('\u0004') + currVal.getConversionDate().getValue() + Character.toString('\u0004');
        return str;
    }

    protected String getFieldValue(FormInformation sourceForm, String fieldName, List<String> tokens) {
        int fieldId = -1;
        for (FieldInformation fieldInfo : sourceForm.getFields().values()) {
            if (!fieldInfo.getName().equals(fieldName)) continue;
            fieldId = fieldInfo.getFieldId();
            break;
        }
        return this.getFieldValue(sourceForm, fieldId, tokens);
    }

    protected String getFieldValue(FormInformation sourceForm, int fieldId, List<String> tokens) {
        int index = -1;
        if (sourceForm.getFields().containsKey(fieldId)) {
            index = sourceForm.getFields().get(fieldId).getTokenIndex();
        }
        return tokens.get(index);
    }

    private String expandFieldValues(String token, FormInformation sourceForm, FormInformation targetForm, List<String> tokens) {
        for (FieldInformation fieldInfo : sourceForm.getFields().values()) {
            String replace = dollar + fieldInfo.getFieldId() + dollar;
            String with = null;
            try {
                if (fieldInfo.getTokenIndex() < tokens.size()) {
                    with = tokens.get(fieldInfo.getTokenIndex());
                }
            }
            catch (Exception e) {
                with = null;
            }
            if (null != with) {
                token = token.replace(replace, with);
                continue;
            }
            token = token.replace(replace, "");
        }
        return token;
    }

    public FormInformation getSourceForm() {
        return this.sourceForm;
    }

    public void setSourceForm(FormInformation sourceForm) {
        this.sourceForm = sourceForm;
    }

    public FormInformation getTargetForm() {
        return this.targetForm;
    }

    public void setTargetForm(FormInformation targetForm) {
        this.targetForm = targetForm;
    }

    private IParser getParser() {
        return this.parser;
    }

    protected void setLastId(String lastId) {
        if (this.expander != null) {
            this.expander.setLastId(lastId);
        }
    }

    public void applyFallbackMappings(MappingOptions maps, FormInformation sourceForm, FormInformation targetForm, List<String> tokens, Integer fields_id) throws ARException {
        Mapping mapping = maps.getFallbacks().get(fields_id);
        if (mapping != null && mapping.getType() == Mapping.Type.COMPOUND) {
            FieldInformation targetField = targetForm.getFields().get(fields_id);
            if (targetField == null) {
                throw new NullPointerException("Field id " + fields_id + "does not exist on schema: " + targetForm.getName());
            }
            String buffer = this.expander.expandAllKeywords(mapping.getCompound(), targetForm, targetField);
            if (buffer != null) {
                buffer = this.expandFieldValues(buffer, sourceForm, targetForm, tokens);
            }
            mapping.setCompoundValue(buffer);
        }
    }
}

