/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.security;

import com.kaazing.gateway.client.security.ChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeRequest;
import com.kaazing.gateway.client.security.ChallengeResponse;
import java.util.ServiceLoader;

public class ChallengeHandlers {
    private static ChallengeHandler _definedDefault = new InternalDefaultChallengeHandler();

    public static void setDefault(ChallengeHandler challengeHandler) {
        if (challengeHandler == null) {
            throw new NullPointerException("challengeHandler");
        }
        _definedDefault = challengeHandler;
    }

    public static ChallengeHandler getDefault() {
        return _definedDefault;
    }

    public static <T extends ChallengeHandler> T load(Class<T> clazz) {
        return ChallengeHandlers.load0(clazz, ServiceLoader.load(clazz));
    }

    public static <T extends ChallengeHandler> T load(Class<T> clazz, ClassLoader clazzLoader) {
        return ChallengeHandlers.load0(clazz, ServiceLoader.load(clazz, clazzLoader));
    }

    static <T extends ChallengeHandler> T load0(Class<T> clazz, ServiceLoader<T> serviceLoader) {
        for (ChallengeHandler challengeHandler : serviceLoader) {
            if (clazz == null || !clazz.isAssignableFrom(challengeHandler.getClass())) continue;
            try {
                return (T)((ChallengeHandler)clazz.cast(challengeHandler.getClass().newInstance()));
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to instantiate class " + challengeHandler.getClass(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access and instantiate class " + challengeHandler.getClass(), e);
            }
        }
        return null;
    }

    static class InternalDefaultChallengeHandler
    extends ChallengeHandler {
        InternalDefaultChallengeHandler() {
        }

        @Override
        public boolean canHandle(ChallengeRequest challengeRequest) {
            return false;
        }

        @Override
        public ChallengeResponse handle(ChallengeRequest challengeRequest) {
            return null;
        }
    }
}

