/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.util;

import com.kaazing.gateway.client.html5.util.GenericURI;
import com.kaazing.gateway.client.html5.util.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class HttpURI
extends GenericURI<HttpURI> {
    @Override
    protected boolean isValidScheme(String scheme) {
        return "http".equals(scheme) || "https".equals(scheme);
    }

    public HttpURI(String location) throws URISyntaxException {
        this(new URI(location));
    }

    HttpURI(URI uri) throws URISyntaxException {
        super(uri);
    }

    @Override
    protected HttpURI duplicate(URI uri) {
        try {
            return new HttpURI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isSecure() {
        return "https".equals(this.uri.getScheme());
    }

    public static HttpURI replaceScheme(GenericURI<?> location, String scheme) throws URISyntaxException {
        return HttpURI.replaceScheme(location.getURI(), scheme);
    }

    public static HttpURI replaceScheme(URI location, String scheme) throws URISyntaxException {
        URI uri = URIUtils.replaceScheme(location, scheme);
        return new HttpURI(uri);
    }
}

