/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.EncoderOutput;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeEncoder;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeEncoderImpl;

public class WebSocketNativeCodec
extends WebSocketHandlerAdapter {
    private WebSocketNativeEncoder encoder = new WebSocketNativeEncoderImpl();
    private EncoderOutput<WebSocketChannel> out;

    @Override
    public void processBinaryMessage(WebSocketChannel channel, ByteBuffer message) {
        this.encoder.encodeBinaryMessage(channel, message, this.out);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        this.encoder.encodeTextMessage(channel, message, this.out);
    }

    @Override
    public void setNextHandler(final WebSocketHandler handler) {
        super.setNextHandler(handler);
        this.out = new EncoderOutput<WebSocketChannel>(){

            @Override
            public void write(WebSocketChannel channel, ByteBuffer buffer) {
                handler.processBinaryMessage(channel, buffer);
            }
        };
        this.nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeCodec.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeCodec.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeCodec.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketNativeCodec.this.listener.messageReceived(channel, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeCodec.this.listener.connectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeCodec.this.listener.connectionClosed(channel);
            }
        });
    }
}

