/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.auth.AuthenticationUtil;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketReAuthenticateHandler;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeChannel;
import com.kaazing.gateway.client.html5.util.HttpURI;
import com.kaazing.gateway.client.html5.util.WSURI;
import com.kaazing.gateway.client.security.ChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeRequest;
import com.kaazing.gateway.client.security.ChallengeResponse;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketNativeAuthenticationHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeAuthenticationHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private void handleAuthenticationRequested(WebSocketChannel channel, String location, String challenge) {
        LOG.entering(CLASS_NAME, "handleAuthenticationRequested");
        channel.authenticationReceived = true;
        WebSocketNativeChannel ch = (WebSocketNativeChannel)channel;
        WSURI serverURI = ch.redirectUri != null ? ch.redirectUri : channel.getLocation();
        if ("x-kaazing-http-revalidate".equals(challenge)) {
            String url = serverURI.getHttpEquivalentScheme() + "://" + serverURI.getURI().getAuthority() + location;
            WebSocketReAuthenticateHandler reAuthHandler = new WebSocketReAuthenticateHandler();
            try {
                WebSocketEmulatedChannel revalidateChannel = new WebSocketEmulatedChannel(serverURI, channel.getProtocol(), channel.isBinary);
                reAuthHandler.processOpen(revalidateChannel, new HttpURI(url));
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            return;
        }
        ChallengeRequest challengeRequest = new ChallengeRequest(serverURI.toString(), challenge);
        try {
            channel.challengeResponse = AuthenticationUtil.getChallengeResponse(challengeRequest, channel.challengeResponse);
        }
        catch (Exception e) {
            this.clearAuthenticationCredentials(channel);
            this.doError(channel);
            return;
        }
        char[] authResponse = channel.challengeResponse.getCredentials();
        if (authResponse == null) {
            this.doError(channel);
            return;
        }
        this.processAuthorize(channel, String.valueOf(authResponse));
        this.clearAuthenticationCredentials(channel);
    }

    private void doError(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "handleConnectionClosed");
        this.nextHandler.processClose(channel);
        this.listener.connectionClosed(channel);
    }

    private void clearAuthenticationCredentials(WebSocketChannel channel) {
        ChallengeHandler nextChallengeHandler = null;
        if (channel.challengeResponse != null) {
            nextChallengeHandler = channel.challengeResponse.getNextChallengeHandler();
            channel.challengeResponse.clearCredentials();
            channel.challengeResponse = null;
        }
        channel.challengeResponse = new ChallengeResponse(null, nextChallengeHandler);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeAuthenticationHandler.this.handleAuthenticationRequested(channel, location, challenge);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketNativeAuthenticationHandler.this.listener.messageReceived(channel, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionFailed(channel);
            }
        });
    }
}

