/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.EncoderOutput;
import com.kaazing.gateway.client.html5.impl.WebSocketUtil;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedEncoder;
import com.kaazing.gateway.client.html5.util.StringUtils;

public class WebSocketEmulatedEncoderImpl<C>
implements WebSocketEmulatedEncoder<C> {
    private static final byte WS_TEXT_FRAME_START = 0;
    private static final byte WS_TEXT_FRAME_END = -1;
    private static final byte WS_BINARY_FRAME_START = -128;

    @Override
    public void encodeBinaryMessage(C channel, ByteBuffer message, EncoderOutput<C> out) {
        int length = message.remaining();
        ByteBuffer frame = ByteBuffer.allocate(length + 6);
        frame.put((byte)-128);
        WebSocketUtil.encodeLength(frame, length);
        frame.putBuffer(message.duplicate());
        frame.flip();
        out.write(channel, frame);
    }

    @Override
    public void encodeTextMessage(C channel, String message, EncoderOutput<C> out) {
        byte[] payload = StringUtils.getUtf8Bytes(message);
        ByteBuffer frame = ByteBuffer.allocate(payload.length + 2);
        frame.put((byte)0);
        frame.putBytes(payload);
        frame.put((byte)-1);
        frame.flip();
        out.write(channel, frame);
    }
}

