/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jportmap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrVoid;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerStub;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpServerTransport;
import org.acplt.oncrpc.server.OncRpcUdpServerTransport;

public class jportmap
extends OncRpcServerStub
implements OncRpcDispatchable {
    public InetAddress[] locals = null;
    public Vector servers = new Vector();
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;

    public jportmap() throws OncRpcException, IOException {
        this.info = new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(100000, 2)};
        this.transports = new OncRpcServerTransport[]{new OncRpcUdpServerTransport(this, 111, this.info, 32768), new OncRpcTcpServerTransport(this, 111, this.info, 32768)};
        this.servers.addElement(new OncRpcServerIdent(100000, 2, 6, 111));
        this.servers.addElement(new OncRpcServerIdent(100000, 2, 17, 111));
        try {
            InetAddress loopback = InetAddress.getByName("127.0.0.1");
            InetAddress[] addrs = InetAddress.getAllByName("127.0.0.1");
            boolean loopbackIncluded = false;
            for (int idx = 0; idx < addrs.length; ++idx) {
                if (!addrs[idx].equals(loopback)) continue;
                loopbackIncluded = true;
                break;
            }
            if (loopbackIncluded) {
                this.locals = addrs;
            } else {
                this.locals = new InetAddress[addrs.length + 1];
                this.locals[0] = loopback;
                System.arraycopy(addrs, 0, this.locals, 1, addrs.length);
            }
        }
        catch (UnknownHostException e) {
            this.locals = new InetAddress[1];
            this.locals[0] = InetAddress.getByName("127.0.0.1");
        }
    }

    OncRpcGetPortResult getPort(OncRpcServerIdent params) {
        OncRpcServerIdent ident = null;
        OncRpcGetPortResult result = new OncRpcGetPortResult();
        int size = this.servers.size();
        for (int idx = 0; idx < size; ++idx) {
            OncRpcServerIdent svr = (OncRpcServerIdent)this.servers.get(idx);
            if (svr.program != params.program || svr.protocol != params.protocol) continue;
            if (svr.version == params.version) {
                result.port = svr.port;
                return result;
            }
            ident = svr;
        }
        result.port = ident == null ? 0 : ident.port;
        return result;
    }

    XdrBoolean setPort(OncRpcServerIdent params) {
        if (params.program != 100000) {
            int size = this.servers.size();
            for (int idx = 0; idx < size; ++idx) {
                OncRpcServerIdent svr = (OncRpcServerIdent)this.servers.get(idx);
                if (svr.program != params.program || svr.version != params.version || svr.protocol != params.protocol) continue;
                return new XdrBoolean(svr.port == params.port);
            }
            this.servers.addElement(params);
            return new XdrBoolean(true);
        }
        return new XdrBoolean(false);
    }

    XdrBoolean unsetPort(OncRpcServerIdent params) {
        boolean ok = false;
        if (params.program != 100000) {
            int size = this.servers.size();
            for (int idx = size - 1; idx >= 0; --idx) {
                OncRpcServerIdent svr = (OncRpcServerIdent)this.servers.get(idx);
                if (svr.program != params.program || svr.version != params.version) continue;
                this.servers.removeElementAt(idx);
                ok = true;
            }
        }
        return new XdrBoolean(ok);
    }

    OncRpcDumpResult listServers() {
        OncRpcDumpResult result = new OncRpcDumpResult();
        result.servers = this.servers;
        return result;
    }

    boolean isLocalAddress(InetAddress addr) {
        int size = this.locals.length;
        for (int idx = 0; idx < size; ++idx) {
            if (!addr.equals(this.locals[idx])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispatchOncRpcCall(OncRpcCallInformation call, int program, int version, int procedure) throws OncRpcException, IOException {
        if (program == 100000) {
            if (version == 2) {
                switch (procedure) {
                    case 0: {
                        call.retrieveCall(XdrVoid.XDR_VOID);
                        call.reply(XdrVoid.XDR_VOID);
                        break;
                    }
                    case 3: {
                        OncRpcServerIdent params = new OncRpcServerIdent();
                        call.retrieveCall(params);
                        OncRpcGetPortResult result = this.getPort(params);
                        call.reply(result);
                        break;
                    }
                    case 1: {
                        OncRpcServerIdent params = new OncRpcServerIdent();
                        call.retrieveCall(params);
                        XdrBoolean result = this.isLocalAddress(call.peerAddress) ? this.setPort(params) : new XdrBoolean(false);
                        call.reply(result);
                        break;
                    }
                    case 2: {
                        OncRpcServerIdent params = new OncRpcServerIdent();
                        call.retrieveCall(params);
                        XdrBoolean result = this.isLocalAddress(call.peerAddress) ? this.unsetPort(params) : new XdrBoolean(false);
                        call.reply(result);
                        break;
                    }
                    case 4: {
                        call.retrieveCall(XdrVoid.XDR_VOID);
                        OncRpcDumpResult result = this.listServers();
                        call.reply(result);
                        break;
                    }
                    default: {
                        call.failProcedureUnavailable();
                        break;
                    }
                }
            } else {
                call.failProgramMismatch(2, 2);
            }
        } else {
            call.failProgramUnavailable();
        }
    }

    public static void main(String[] args) {
        try {
            jportmap pmap = new jportmap();
            pmap.run(pmap.transports);
            pmap.close(pmap.transports);
        }
        catch (OncRpcException e) {
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }
}

