/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.sse;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.EventSource;
import com.kaazing.gateway.client.html5.impl.bridge.HttpRequestBridgeHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestAuthenticationHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandlerFactory;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestRedirectHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.sse.EventStreamListener;
import com.kaazing.gateway.client.html5.util.HttpURI;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventStream {
    private final String CLASS_NAME = EventStream.class.getName();
    private final Logger LOG = Logger.getLogger(this.CLASS_NAME);
    static final HttpRequestHandlerFactory SSE_HANDLER_FACTORY = new HttpRequestHandlerFactory(){

        @Override
        public HttpRequestHandler createHandler() {
            HttpRequestAuthenticationHandler authHandler = new HttpRequestAuthenticationHandler();
            HttpRequestRedirectHandler redirectHandler = new HttpRequestRedirectHandler();
            HttpRequestBridgeHandler bridgeHandler = new HttpRequestBridgeHandler();
            authHandler.setNextHandler(redirectHandler);
            redirectHandler.setNextHandler(bridgeHandler);
            return authHandler;
        }
    };
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String MESSAGE = "message";
    private static final transient Timer timer = new Timer("reconnect", true);
    private EventSource.ReadyState readyState = EventSource.ReadyState.CONNECTING;
    private String lastEventId = "";
    private boolean aborted = false;
    private boolean errored = false;
    private String sseUrl;
    private int retry = 3000;
    private boolean immediateReconnect = false;
    private String messageBuffer = "";
    private HttpRequest sseSource;
    private AtomicBoolean progressEventReceived = new AtomicBoolean(false);
    private AtomicBoolean reconnected = new AtomicBoolean(false);
    private HttpRequestHandler sseHandler;
    private EventStreamListener listener;

    public EventStream(String sseUrl) throws IOException {
        this.LOG.entering(this.CLASS_NAME, "<init>", sseUrl);
        try {
            new URI(sseUrl);
        }
        catch (URISyntaxException e1) {
            this.LOG.warning("Invalid URL for Event Stream");
            throw new IllegalArgumentException("Invalid URL for Event Stream: " + sseUrl, e1);
        }
        this.sseUrl = sseUrl;
        this.sseHandler = SSE_HANDLER_FACTORY.createHandler();
        this.sseHandler.setListener(new EventStreamHttpRequestListener());
    }

    public EventSource.ReadyState getReadyState() {
        return this.readyState;
    }

    public void stop() {
        this.LOG.entering(this.CLASS_NAME, "stop");
        this.readyState = EventSource.ReadyState.CLOSED;
        this.sseHandler.processAbort(this.sseSource);
        this.aborted = true;
    }

    public void connect() throws IOException {
        this.LOG.entering(this.CLASS_NAME, "connect");
        if (this.lastEventId != null && this.lastEventId.length() > 0) {
            this.sseUrl = this.sseUrl + (this.sseUrl.indexOf("?") == -1 ? "?" : "&") + ".ka=" + this.lastEventId;
        }
        try {
            HttpURI uri = new HttpURI(this.sseUrl);
            this.sseSource = new HttpRequest(HttpRequest.Method.GET, uri, true);
            this.sseHandler.processOpen(this.sseSource);
            if (!this.reconnected.get()) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                    }
                };
                Timer timer = new Timer();
                timer.schedule(timerTask, 3000L);
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.INFO, e.getMessage(), e);
            this.doError();
        }
    }

    private synchronized void reconnect() {
        this.LOG.entering(this.CLASS_NAME, "reconnect");
        if (this.readyState != EventSource.ReadyState.CLOSED) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        EventStream.this.connect();
                    }
                    catch (IOException e) {
                        EventStream.this.LOG.log(Level.INFO, e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                }
            };
            timer.schedule(task, this.retry);
        }
    }

    private synchronized void processProgressEvent(String message) {
        this.LOG.entering(this.CLASS_NAME, "processProgressEvent", message);
        try {
            String line;
            this.messageBuffer = this.messageBuffer + message;
            String field = null;
            String value = null;
            String name = MESSAGE;
            String data = "";
            this.immediateReconnect = false;
            while (!this.aborted && !this.errored && (line = this.fetchLineFromBuffer()) != null) {
                int colonAt = line.indexOf(58);
                if (colonAt == -1) {
                    field = line;
                    value = "";
                } else {
                    if (colonAt == 0) continue;
                    field = line.substring(0, colonAt);
                    int valueAt = colonAt + 1;
                    if (line.charAt(valueAt) == ' ') {
                        ++valueAt;
                    }
                    value = line.substring(valueAt);
                }
                if (field.equals("event")) {
                    name = value;
                    continue;
                }
                if (field.equals("id")) {
                    this.lastEventId = value;
                    continue;
                }
                if (field.equals("retry")) {
                    this.retry = Integer.parseInt(value);
                    continue;
                }
                if (field.equals("data")) {
                    if ((value == null || value.length() <= 0) && (name == null || name.length() <= 0 || MESSAGE.equals(name))) continue;
                    data = value;
                    this.doMessage(data);
                    continue;
                }
                if (field.equals("location")) {
                    if (value == null || value.length() <= 0) continue;
                    this.sseUrl = value;
                    continue;
                }
                if (!field.equals("reconnect")) continue;
                this.immediateReconnect = true;
            }
            if (this.immediateReconnect) {
                this.retry = 0;
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.INFO, e.getMessage(), e);
            this.doError();
        }
    }

    private String fetchLineFromBuffer() {
        this.LOG.entering(this.CLASS_NAME, "fetchLineFromBuffer");
        int lf = this.messageBuffer.indexOf("\n");
        if (lf == -1) {
            lf = this.messageBuffer.indexOf("\r");
        }
        if (lf != -1) {
            String ret = this.messageBuffer.substring(0, lf);
            this.messageBuffer = this.messageBuffer.substring(lf + 1);
            return ret;
        }
        return null;
    }

    private void doOpen() {
        this.readyState = EventSource.ReadyState.OPEN;
        this.listener.streamOpened();
    }

    private void doMessage(String data) {
        if (this.getReadyState() != EventSource.ReadyState.OPEN) {
            return;
        }
        this.listener.messageReceived(data);
    }

    private void doError() {
        if (this.getReadyState() == EventSource.ReadyState.CLOSED) {
            return;
        }
        this.errored = true;
        this.listener.streamErrored();
    }

    public void setListener(EventStreamListener listener) {
        this.listener = listener;
    }

    private class EventStreamHttpRequestListener
    implements HttpRequestListener {
        private final String CLASS_NAME = EventStreamHttpRequestListener.class.getName();
        private final Logger LOG = Logger.getLogger(this.CLASS_NAME);
        boolean reconnectScheduled = false;

        EventStreamHttpRequestListener() {
            this.LOG.entering(this.CLASS_NAME, "<init>");
        }

        @Override
        public void requestReady(HttpRequest request) {
        }

        @Override
        public void requestOpened(HttpRequest request) {
            EventStream.this.doOpen();
        }

        @Override
        public void requestProgressed(HttpRequest request, ByteBuffer payload) {
            EventStream.this.progressEventReceived.set(true);
            String response = payload.getString(UTF_8);
            EventStream.this.processProgressEvent(response);
        }

        @Override
        public void requestLoaded(HttpRequest request, HttpResponse response) {
            if (EventStream.this.readyState != EventSource.ReadyState.CLOSED && EventStream.this.immediateReconnect) {
                EventStream.this.retry = 0;
                if (!this.reconnectScheduled) {
                    EventStream.this.reconnect();
                }
            }
        }

        @Override
        public void requestAborted(HttpRequest request) {
        }

        @Override
        public void requestClosed(HttpRequest request) {
        }

        @Override
        public void errorOccurred(HttpRequest request) {
            EventStream.this.doError();
        }
    }
}

