/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.validation;

import com.bmc.thirdparty.org.springframework.beans.PropertyAccessException;
import com.bmc.thirdparty.org.springframework.context.support.DefaultMessageSourceResolvable;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.validation.BindingErrorProcessor;
import com.bmc.thirdparty.org.springframework.validation.BindingResult;
import com.bmc.thirdparty.org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    @Override
    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String fixedField = bindingResult.getNestedPath() + missingField;
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), fixedField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), fixedField, "", true, codes, arguments, "Field '" + fixedField + "' is required"));
    }

    @Override
    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyName();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        Object rejectedValue = ex.getValue();
        if (rejectedValue != null && rejectedValue.getClass().isArray()) {
            rejectedValue = StringUtils.arrayToCommaDelimitedString(ObjectUtils.toObjectArray(rejectedValue));
        }
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field, rejectedValue, true, codes, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        return new Object[]{new DefaultMessageSourceResolvable(codes, field)};
    }
}

