/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util.concurrent;

import com.bmc.thirdparty.org.springframework.util.concurrent.FailureCallback;
import com.bmc.thirdparty.org.springframework.util.concurrent.ListenableFuture;
import com.bmc.thirdparty.org.springframework.util.concurrent.ListenableFutureCallback;
import com.bmc.thirdparty.org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import com.bmc.thirdparty.org.springframework.util.concurrent.SuccessCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ListenableFutureTask<T>
extends FutureTask<T>
implements ListenableFuture<T> {
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    public ListenableFutureTask(Callable<T> callable) {
        super(callable);
    }

    public ListenableFutureTask(Runnable runnable, T result) {
        super(runnable, result);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbacks.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.callbacks.addSuccessCallback(successCallback);
        this.callbacks.addFailureCallback(failureCallback);
    }

    @Override
    protected final void done() {
        Throwable cause;
        try {
            Object result = this.get();
            this.callbacks.success(result);
            return;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException ex) {
            cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
        }
        catch (Throwable ex) {
            cause = ex;
        }
        this.callbacks.failure(cause);
    }
}

