/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.concurrent;

import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.lang.UsesJava7;
import com.bmc.thirdparty.org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import com.bmc.thirdparty.org.springframework.scheduling.concurrent.ScheduledExecutorTask;
import com.bmc.thirdparty.org.springframework.scheduling.support.DelegatingErrorHandlingRunnable;
import com.bmc.thirdparty.org.springframework.scheduling.support.TaskUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ScheduledExecutorFactoryBean
extends ExecutorConfigurationSupport
implements FactoryBean<ScheduledExecutorService> {
    private static final boolean setRemoveOnCancelPolicyAvailable = ClassUtils.hasMethod(ScheduledThreadPoolExecutor.class, "setRemoveOnCancelPolicy", Boolean.TYPE);
    private int poolSize = 1;
    private ScheduledExecutorTask[] scheduledExecutorTasks;
    private boolean removeOnCancelPolicy = false;
    private boolean continueScheduledExecutionAfterException = false;
    private boolean exposeUnconfigurableExecutor = false;
    private ScheduledExecutorService exposedExecutor;

    public void setPoolSize(int poolSize) {
        Assert.isTrue(poolSize > 0, "'poolSize' must be 1 or higher");
        this.poolSize = poolSize;
    }

    public void setScheduledExecutorTasks(ScheduledExecutorTask ... scheduledExecutorTasks) {
        this.scheduledExecutorTasks = scheduledExecutorTasks;
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.removeOnCancelPolicy = removeOnCancelPolicy;
    }

    public void setContinueScheduledExecutionAfterException(boolean continueScheduledExecutionAfterException) {
        this.continueScheduledExecutionAfterException = continueScheduledExecutionAfterException;
    }

    public void setExposeUnconfigurableExecutor(boolean exposeUnconfigurableExecutor) {
        this.exposeUnconfigurableExecutor = exposeUnconfigurableExecutor;
    }

    @Override
    @UsesJava7
    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ScheduledExecutorService executor = this.createExecutor(this.poolSize, threadFactory, rejectedExecutionHandler);
        if (this.removeOnCancelPolicy) {
            if (setRemoveOnCancelPolicyAvailable && executor instanceof ScheduledThreadPoolExecutor) {
                ((ScheduledThreadPoolExecutor)executor).setRemoveOnCancelPolicy(true);
            } else {
                this.logger.info("Could not apply remove-on-cancel policy - not a Java 7+ ScheduledThreadPoolExecutor");
            }
        }
        if (!ObjectUtils.isEmpty(this.scheduledExecutorTasks)) {
            this.registerTasks(this.scheduledExecutorTasks, executor);
        }
        this.exposedExecutor = this.exposeUnconfigurableExecutor ? Executors.unconfigurableScheduledExecutorService(executor) : executor;
        return executor;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    protected void registerTasks(ScheduledExecutorTask[] tasks, ScheduledExecutorService executor) {
        for (ScheduledExecutorTask task : tasks) {
            Runnable runnable = this.getRunnableToSchedule(task);
            if (task.isOneTimeTask()) {
                executor.schedule(runnable, task.getDelay(), task.getTimeUnit());
                continue;
            }
            if (task.isFixedRate()) {
                executor.scheduleAtFixedRate(runnable, task.getDelay(), task.getPeriod(), task.getTimeUnit());
                continue;
            }
            executor.scheduleWithFixedDelay(runnable, task.getDelay(), task.getPeriod(), task.getTimeUnit());
        }
    }

    protected Runnable getRunnableToSchedule(ScheduledExecutorTask task) {
        return this.continueScheduledExecutionAfterException ? new DelegatingErrorHandlingRunnable(task.getRunnable(), TaskUtils.LOG_AND_SUPPRESS_ERROR_HANDLER) : new DelegatingErrorHandlingRunnable(task.getRunnable(), TaskUtils.LOG_AND_PROPAGATE_ERROR_HANDLER);
    }

    @Override
    public ScheduledExecutorService getObject() {
        return this.exposedExecutor;
    }

    @Override
    public Class<? extends ScheduledExecutorService> getObjectType() {
        return this.exposedExecutor != null ? this.exposedExecutor.getClass() : ScheduledExecutorService.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

