/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.concurrent;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jndi.JndiLocatorDelegate;
import com.bmc.thirdparty.org.springframework.jndi.JndiTemplate;
import com.bmc.thirdparty.org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;

public class DefaultManagedAwareThreadFactory
extends CustomizableThreadFactory
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiLocatorDelegate jndiLocator = new JndiLocatorDelegate();
    private String jndiName = "java:comp/DefaultManagedThreadFactory";
    private ThreadFactory threadFactory = this;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiLocator.setJndiTemplate(jndiTemplate);
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiLocator.setJndiEnvironment(jndiEnvironment);
    }

    public void setResourceRef(boolean resourceRef) {
        this.jndiLocator.setResourceRef(resourceRef);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public void afterPropertiesSet() throws NamingException {
        block4: {
            if (this.jndiName != null) {
                try {
                    this.threadFactory = this.jndiLocator.lookup(this.jndiName, ThreadFactory.class);
                }
                catch (NamingException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Failed to find [java:comp/DefaultManagedThreadFactory] in JNDI", ex);
                    }
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("Could not find default managed thread factory in JNDI - proceeding with default local thread factory");
                }
            }
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return this.threadFactory.newThread(runnable);
    }
}

