/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jndi;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.jndi.JndiCallback;
import com.bmc.thirdparty.org.springframework.jndi.TypeMismatchNamingException;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(JndiCallback<T> contextCallback) throws NamingException {
        Context ctx = this.getContext();
        try {
            T t = contextCallback.doInContext(ctx);
            return t;
        }
        finally {
            this.releaseContext(ctx);
        }
    }

    public Context getContext() throws NamingException {
        return this.createInitialContext();
    }

    public void releaseContext(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                this.logger.debug("Could not close JNDI InitialContext", ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        Hashtable icEnv = null;
        Properties env = this.getEnvironment();
        if (env != null) {
            icEnv = new Hashtable(env.size());
            CollectionUtils.mergePropertiesIntoMap(env, icEnv);
        }
        return new InitialContext(icEnv);
    }

    public Object lookup(final String name) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up JNDI object with name [" + name + "]");
        }
        return this.execute(new JndiCallback<Object>(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                Object located = ctx.lookup(name);
                if (located == null) {
                    throw new NameNotFoundException("JNDI object with [" + name + "] not found: JNDI implementation returned null");
                }
                return located;
            }
        });
    }

    public <T> T lookup(String name, Class<T> requiredType) throws NamingException {
        Object jndiObject = this.lookup(name);
        if (requiredType != null && !requiredType.isInstance(jndiObject)) {
            throw new TypeMismatchNamingException(name, requiredType, jndiObject != null ? jndiObject.getClass() : null);
        }
        return (T)jndiObject;
    }

    public void bind(final String name, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Binding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback<Object>(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                ctx.bind(name, object);
                return null;
            }
        });
    }

    public void rebind(final String name, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rebinding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback<Object>(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                ctx.rebind(name, object);
                return null;
            }
        });
    }

    public void unbind(final String name) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unbinding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback<Object>(){

            @Override
            public Object doInContext(Context ctx) throws NamingException {
                ctx.unbind(name);
                return null;
            }
        });
    }
}

