/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.format.datetime.joda;

import com.bmc.thirdparty.org.springframework.context.i18n.LocaleContext;
import com.bmc.thirdparty.org.springframework.context.i18n.LocaleContextHolder;
import com.bmc.thirdparty.org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class JodaTimeContext {
    private Chronology chronology;
    private DateTimeZone timeZone;

    public void setChronology(Chronology chronology) {
        this.chronology = chronology;
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTimeFormatter getFormatter(DateTimeFormatter formatter) {
        if (this.chronology != null) {
            formatter = formatter.withChronology(this.chronology);
        }
        if (this.timeZone != null) {
            formatter = formatter.withZone(this.timeZone);
        } else {
            TimeZone timeZone;
            LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
            if (localeContext instanceof TimeZoneAwareLocaleContext && (timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone()) != null) {
                formatter = formatter.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
            }
        }
        return formatter;
    }
}

