/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.format.datetime.joda;

import com.bmc.thirdparty.org.springframework.format.annotation.DateTimeFormat;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeFormatterFactory {
    private String pattern;
    private DateTimeFormat.ISO iso;
    private String style;
    private TimeZone timeZone;

    public DateTimeFormatterFactory() {
    }

    public DateTimeFormatterFactory(String pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setIso(DateTimeFormat.ISO iso) {
        this.iso = iso;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public DateTimeFormatter createDateTimeFormatter() {
        return this.createDateTimeFormatter(DateTimeFormat.mediumDateTime());
    }

    public DateTimeFormatter createDateTimeFormatter(DateTimeFormatter fallbackFormatter) {
        DateTimeFormatter dateTimeFormatter;
        block9: {
            block10: {
                block8: {
                    dateTimeFormatter = null;
                    if (!StringUtils.hasLength(this.pattern)) break block8;
                    dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
                    break block9;
                }
                if (this.iso == null || this.iso == DateTimeFormat.ISO.NONE) break block10;
                switch (this.iso) {
                    case DATE: {
                        dateTimeFormatter = ISODateTimeFormat.date();
                        break block9;
                    }
                    case TIME: {
                        dateTimeFormatter = ISODateTimeFormat.time();
                        break block9;
                    }
                    case DATE_TIME: {
                        dateTimeFormatter = ISODateTimeFormat.dateTime();
                        break block9;
                    }
                    case NONE: {
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported ISO format: " + (Object)((Object)this.iso));
                    }
                }
            }
            if (StringUtils.hasLength(this.style)) {
                dateTimeFormatter = DateTimeFormat.forStyle((String)this.style);
            }
        }
        if (dateTimeFormatter != null && this.timeZone != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        }
        return dateTimeFormatter != null ? dateTimeFormatter : fallbackFormatter;
    }
}

