/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.expression.spel.ast;

import com.bmc.thirdparty.org.springframework.expression.EvaluationException;
import com.bmc.thirdparty.org.springframework.expression.spel.ExpressionState;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelEvaluationException;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelMessage;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.Operator;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.bmc.thirdparty.org.springframework.expression.spel.support.BooleanTypedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class OperatorMatches
extends Operator {
    public OperatorMatches(int pos, SpelNodeImpl ... operands) {
        super("matches", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        String left = leftOp.getValue(state, String.class);
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        if (!(left instanceof String)) {
            throw new SpelEvaluationException(leftOp.getStartPosition(), SpelMessage.INVALID_FIRST_OPERAND_FOR_MATCHES_OPERATOR, left);
        }
        if (!(right instanceof String)) {
            throw new SpelEvaluationException(rightOp.getStartPosition(), SpelMessage.INVALID_SECOND_OPERAND_FOR_MATCHES_OPERATOR, right);
        }
        try {
            Pattern pattern = Pattern.compile((String)right);
            Matcher matcher = pattern.matcher(left);
            return BooleanTypedValue.forValue(matcher.matches());
        }
        catch (PatternSyntaxException ex) {
            throw new SpelEvaluationException(rightOp.getStartPosition(), (Throwable)ex, SpelMessage.INVALID_PATTERN, right);
        }
    }
}

