/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.expression.spel.ast;

import com.bmc.thirdparty.org.springframework.asm.MethodVisitor;
import com.bmc.thirdparty.org.springframework.asm.Type;
import com.bmc.thirdparty.org.springframework.expression.EvaluationException;
import com.bmc.thirdparty.org.springframework.expression.TypedValue;
import com.bmc.thirdparty.org.springframework.expression.spel.CodeFlow;
import com.bmc.thirdparty.org.springframework.expression.spel.ExpressionState;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelEvaluationException;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelMessage;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.Operator;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.bmc.thirdparty.org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorInstanceof
extends Operator {
    private Class<?> type;

    public OperatorInstanceof(int pos, SpelNodeImpl ... operands) {
        super("instanceof", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue left = this.getLeftOperand().getValueInternal(state);
        TypedValue right = this.getRightOperand().getValueInternal(state);
        Object leftValue = left.getValue();
        Object rightValue = right.getValue();
        BooleanTypedValue result = null;
        if (rightValue == null || !(rightValue instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, rightValue == null ? "null" : rightValue.getClass().getName());
        }
        Class rightClass = (Class)rightValue;
        result = leftValue == null ? BooleanTypedValue.FALSE : BooleanTypedValue.forValue(rightClass.isAssignableFrom(leftValue.getClass()));
        this.type = rightClass;
        this.exitTypeDescriptor = "Z";
        return result;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null && this.getLeftOperand().isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.getLeftOperand().generateCode(mv, cf);
        mv.visitTypeInsn(193, Type.getInternalName(this.type));
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

