/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.expression.spel.ast;

import com.bmc.thirdparty.org.springframework.core.convert.TypeDescriptor;
import java.util.List;

public class FormatHelper {
    public static String formatMethodForMessage(String name, List<TypeDescriptor> argumentTypes) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("(");
        for (int i = 0; i < argumentTypes.size(); ++i) {
            TypeDescriptor typeDescriptor;
            if (i > 0) {
                sb.append(",");
            }
            if ((typeDescriptor = argumentTypes.get(i)) != null) {
                sb.append(FormatHelper.formatClassNameForMessage(typeDescriptor.getType()));
                continue;
            }
            sb.append(FormatHelper.formatClassNameForMessage(null));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatClassNameForMessage(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder();
            int dims = 1;
            Class<?> baseClass = clazz.getComponentType();
            while (baseClass.isArray()) {
                baseClass = baseClass.getComponentType();
                ++dims;
            }
            sb.append(baseClass.getName());
            for (int i = 0; i < dims; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
        return clazz.getName();
    }
}

