/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.convert.support;

import com.bmc.thirdparty.org.springframework.core.convert.ConversionService;
import com.bmc.thirdparty.org.springframework.core.convert.TypeDescriptor;
import com.bmc.thirdparty.org.springframework.core.convert.converter.ConditionalConverter;
import com.bmc.thirdparty.org.springframework.core.convert.converter.Converter;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;

final class EnumToStringConverter
implements Converter<Enum<?>, String>,
ConditionalConverter {
    private final ConversionService conversionService;

    public EnumToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (Class<?> interfaceType : ClassUtils.getAllInterfacesForClass(sourceType.getType())) {
            if (!this.conversionService.canConvert(TypeDescriptor.valueOf(interfaceType), targetType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String convert(Enum<?> source) {
        return source.name();
    }
}

