/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.convert.support;

import com.bmc.thirdparty.org.springframework.core.convert.ConversionService;
import com.bmc.thirdparty.org.springframework.core.convert.TypeDescriptor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.beans.PropertyEditorSupport;

public class ConvertingPropertyEditorAdapter
extends PropertyEditorSupport {
    private final ConversionService conversionService;
    private final TypeDescriptor targetDescriptor;
    private final boolean canConvertToString;

    public ConvertingPropertyEditorAdapter(ConversionService conversionService, TypeDescriptor targetDescriptor) {
        Assert.notNull(conversionService, "ConversionService must not be null");
        Assert.notNull(targetDescriptor, "TypeDescriptor must not be null");
        this.conversionService = conversionService;
        this.targetDescriptor = targetDescriptor;
        this.canConvertToString = conversionService.canConvert(this.targetDescriptor, TypeDescriptor.valueOf(String.class));
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.conversionService.convert(text, TypeDescriptor.valueOf(String.class), this.targetDescriptor));
    }

    @Override
    public String getAsText() {
        if (this.canConvertToString) {
            return (String)this.conversionService.convert(this.getValue(), this.targetDescriptor, TypeDescriptor.valueOf(String.class));
        }
        return null;
    }
}

