/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core;

import com.bmc.thirdparty.org.springframework.core.MethodParameter;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ConcurrentReferenceHashMap;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

abstract class SerializableTypeWrapper {
    private static final Class<?>[] SUPPORTED_SERIALIZABLE_TYPES = new Class[]{GenericArrayType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class};
    private static final Method EQUALS_METHOD = ReflectionUtils.findMethod(Object.class, "equals", Object.class);
    private static final Method GET_TYPE_PROVIDER_METHOD = ReflectionUtils.findMethod(SerializableTypeProxy.class, "getTypeProvider");
    private static final ConcurrentReferenceHashMap<Type, Type> cache = new ConcurrentReferenceHashMap(256);

    SerializableTypeWrapper() {
    }

    public static Type forField(Field field) {
        Assert.notNull(field, "Field must not be null");
        return SerializableTypeWrapper.forTypeProvider(new FieldTypeProvider(field));
    }

    public static Type forMethodParameter(MethodParameter methodParameter) {
        return SerializableTypeWrapper.forTypeProvider(new MethodParameterTypeProvider(methodParameter));
    }

    public static Type forGenericSuperclass(final Class<?> type) {
        return SerializableTypeWrapper.forTypeProvider(new DefaultTypeProvider(){

            @Override
            public Type getType() {
                return type.getGenericSuperclass();
            }
        });
    }

    public static Type[] forGenericInterfaces(final Class<?> type) {
        Type[] result = new Type[type.getGenericInterfaces().length];
        for (int i = 0; i < result.length; ++i) {
            final int index = i;
            result[i] = SerializableTypeWrapper.forTypeProvider(new DefaultTypeProvider(){

                @Override
                public Type getType() {
                    return type.getGenericInterfaces()[index];
                }
            });
        }
        return result;
    }

    public static Type[] forTypeParameters(final Class<?> type) {
        Type[] result = new Type[type.getTypeParameters().length];
        for (int i = 0; i < result.length; ++i) {
            final int index = i;
            result[i] = SerializableTypeWrapper.forTypeProvider(new DefaultTypeProvider(){

                @Override
                public Type getType() {
                    return type.getTypeParameters()[index];
                }
            });
        }
        return result;
    }

    public static <T extends Type> T unwrap(T type) {
        Object unwrapped = type;
        while (unwrapped instanceof SerializableTypeProxy) {
            unwrapped = ((SerializableTypeProxy)((Object)type)).getTypeProvider().getType();
        }
        return unwrapped;
    }

    static Type forTypeProvider(TypeProvider provider) {
        Assert.notNull(provider, "Provider must not be null");
        if (provider.getType() instanceof Serializable || provider.getType() == null) {
            return provider.getType();
        }
        Type cached = cache.get(provider.getType());
        if (cached != null) {
            return cached;
        }
        for (Class<?> type : SUPPORTED_SERIALIZABLE_TYPES) {
            if (!type.isAssignableFrom(provider.getType().getClass())) continue;
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class[] interfaces = new Class[]{type, SerializableTypeProxy.class, Serializable.class};
            TypeProxyInvocationHandler handler = new TypeProxyInvocationHandler(provider);
            cached = (Type)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
            cache.put(provider.getType(), cached);
            return cached;
        }
        throw new IllegalArgumentException("Unsupported Type class " + provider.getType().getClass().getName());
    }

    static class MethodInvokeTypeProvider
    implements TypeProvider {
        private final TypeProvider provider;
        private final String methodName;
        private final int index;
        private transient Object result;

        public MethodInvokeTypeProvider(TypeProvider provider, Method method, int index) {
            this.provider = provider;
            this.methodName = method.getName();
            this.index = index;
            this.result = ReflectionUtils.invokeMethod(method, provider.getType());
        }

        @Override
        public Type getType() {
            if (this.result instanceof Type || this.result == null) {
                return (Type)this.result;
            }
            return ((Type[])this.result)[this.index];
        }

        @Override
        public Object getSource() {
            return null;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            Method method = ReflectionUtils.findMethod(this.provider.getType().getClass(), this.methodName);
            this.result = ReflectionUtils.invokeMethod(method, this.provider.getType());
        }
    }

    static class MethodParameterTypeProvider
    implements TypeProvider {
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final Class<?> declaringClass;
        private final int parameterIndex;
        private transient MethodParameter methodParameter;

        public MethodParameterTypeProvider(MethodParameter methodParameter) {
            if (methodParameter.getMethod() != null) {
                this.methodName = methodParameter.getMethod().getName();
                this.parameterTypes = methodParameter.getMethod().getParameterTypes();
            } else {
                this.methodName = null;
                this.parameterTypes = methodParameter.getConstructor().getParameterTypes();
            }
            this.declaringClass = methodParameter.getDeclaringClass();
            this.parameterIndex = methodParameter.getParameterIndex();
            this.methodParameter = methodParameter;
        }

        @Override
        public Type getType() {
            return this.methodParameter.getGenericParameterType();
        }

        @Override
        public Object getSource() {
            return this.methodParameter;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            try {
                this.methodParameter = this.methodName != null ? new MethodParameter(this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes), this.parameterIndex) : new MethodParameter(this.declaringClass.getDeclaredConstructor(this.parameterTypes), this.parameterIndex);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not find original class structure", ex);
            }
        }
    }

    static class FieldTypeProvider
    implements TypeProvider {
        private final String fieldName;
        private final Class<?> declaringClass;
        private transient Field field;

        public FieldTypeProvider(Field field) {
            this.fieldName = field.getName();
            this.declaringClass = field.getDeclaringClass();
            this.field = field;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public Object getSource() {
            return this.field;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            try {
                this.field = this.declaringClass.getDeclaredField(this.fieldName);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not find original class structure", ex);
            }
        }
    }

    private static class TypeProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final TypeProvider provider;

        public TypeProxyInvocationHandler(TypeProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (GET_TYPE_PROVIDER_METHOD.equals(method)) {
                return this.provider;
            }
            if (EQUALS_METHOD.equals(method)) {
                Object other = args[0];
                if (other instanceof Type) {
                    other = SerializableTypeWrapper.unwrap((Type)other);
                }
                return this.provider.getType().equals(other);
            }
            if (Type.class.equals(method.getReturnType()) && args == null) {
                return SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, -1));
            }
            if (Type[].class.equals(method.getReturnType()) && args == null) {
                Type[] result = new Type[((Type[])method.invoke((Object)this.provider.getType(), args)).length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, i));
                }
                return result;
            }
            try {
                return method.invoke((Object)this.provider.getType(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static abstract class DefaultTypeProvider
    implements TypeProvider {
        private DefaultTypeProvider() {
        }

        @Override
        public Object getSource() {
            return null;
        }
    }

    static interface TypeProvider
    extends Serializable {
        public Type getType();

        public Object getSource();
    }

    static interface SerializableTypeProxy {
        public TypeProvider getTypeProvider();
    }
}

