/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.context.ConfigurableApplicationContext;
import com.bmc.thirdparty.org.springframework.context.annotation.Condition;
import com.bmc.thirdparty.org.springframework.context.annotation.ConditionContext;
import com.bmc.thirdparty.org.springframework.context.annotation.Conditional;
import com.bmc.thirdparty.org.springframework.context.annotation.ConfigurationClassUtils;
import com.bmc.thirdparty.org.springframework.context.annotation.ConfigurationCondition;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.bmc.thirdparty.org.springframework.core.env.Environment;
import com.bmc.thirdparty.org.springframework.core.env.EnvironmentCapable;
import com.bmc.thirdparty.org.springframework.core.io.ResourceLoader;
import com.bmc.thirdparty.org.springframework.core.type.AnnotatedTypeMetadata;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.MultiValueMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ConditionEvaluator {
    private final ConditionContextImpl context;

    public ConditionEvaluator(BeanDefinitionRegistry registry, Environment environment, ResourceLoader resourceLoader) {
        this.context = new ConditionContextImpl(registry, environment, resourceLoader);
    }

    public boolean shouldSkip(AnnotatedTypeMetadata metadata) {
        return this.shouldSkip(metadata, null);
    }

    public boolean shouldSkip(AnnotatedTypeMetadata metadata, ConfigurationCondition.ConfigurationPhase phase) {
        if (metadata == null || !metadata.isAnnotated(Conditional.class.getName())) {
            return false;
        }
        if (phase == null) {
            if (metadata instanceof AnnotationMetadata && ConfigurationClassUtils.isConfigurationCandidate((AnnotationMetadata)metadata)) {
                return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }
            return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String[] conditionClasses : this.getConditionClasses(metadata)) {
            for (String conditionClass : conditionClasses) {
                Condition condition = this.getCondition(conditionClass, this.context.getClassLoader());
                conditions.add(condition);
            }
        }
        AnnotationAwareOrderComparator.sort(conditions);
        for (Condition condition : conditions) {
            ConfigurationCondition.ConfigurationPhase requiredPhase = null;
            if (condition instanceof ConfigurationCondition) {
                requiredPhase = ((ConfigurationCondition)condition).getConfigurationPhase();
            }
            if (requiredPhase != null && requiredPhase != phase || condition.matches(this.context, metadata)) continue;
            return true;
        }
        return false;
    }

    private List<String[]> getConditionClasses(AnnotatedTypeMetadata metadata) {
        MultiValueMap<String, Object> attributes = metadata.getAllAnnotationAttributes(Conditional.class.getName(), true);
        List<String[]> values = attributes != null ? (List<String[]>)attributes.get("value") : null;
        return values != null ? values : Collections.emptyList();
    }

    private Condition getCondition(String conditionClassName, ClassLoader classloader) {
        Class<?> conditionClass = ClassUtils.resolveClassName(conditionClassName, classloader);
        return (Condition)BeanUtils.instantiateClass(conditionClass);
    }

    private static class ConditionContextImpl
    implements ConditionContext {
        private final BeanDefinitionRegistry registry;
        private final ConfigurableListableBeanFactory beanFactory;
        private final Environment environment;
        private final ResourceLoader resourceLoader;

        public ConditionContextImpl(BeanDefinitionRegistry registry, Environment environment, ResourceLoader resourceLoader) {
            this.registry = registry;
            this.beanFactory = this.deduceBeanFactory(registry);
            this.environment = environment != null ? environment : this.deduceEnvironment(registry);
            this.resourceLoader = resourceLoader != null ? resourceLoader : this.deduceResourceLoader(registry);
        }

        private ConfigurableListableBeanFactory deduceBeanFactory(BeanDefinitionRegistry source) {
            if (source instanceof ConfigurableListableBeanFactory) {
                return (ConfigurableListableBeanFactory)((Object)source);
            }
            if (source instanceof ConfigurableApplicationContext) {
                return ((ConfigurableApplicationContext)((Object)source)).getBeanFactory();
            }
            return null;
        }

        private Environment deduceEnvironment(BeanDefinitionRegistry source) {
            if (source instanceof EnvironmentCapable) {
                return ((EnvironmentCapable)((Object)source)).getEnvironment();
            }
            return null;
        }

        private ResourceLoader deduceResourceLoader(BeanDefinitionRegistry source) {
            if (source instanceof ResourceLoader) {
                return (ResourceLoader)((Object)source);
            }
            return null;
        }

        @Override
        public BeanDefinitionRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public ConfigurableListableBeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        @Override
        public Environment getEnvironment() {
            return this.environment;
        }

        @Override
        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        @Override
        public ClassLoader getClassLoader() {
            if (this.resourceLoader != null) {
                return this.resourceLoader.getClassLoader();
            }
            if (this.beanFactory != null) {
                return this.beanFactory.getBeanClassLoader();
            }
            return null;
        }
    }
}

