/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.context.annotation.AnnotationConfigUtils;
import com.bmc.thirdparty.org.springframework.context.annotation.Scope;
import com.bmc.thirdparty.org.springframework.context.annotation.ScopeMetadata;
import com.bmc.thirdparty.org.springframework.context.annotation.ScopeMetadataResolver;
import com.bmc.thirdparty.org.springframework.context.annotation.ScopedProxyMode;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotatedTypeMetadata;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.annotation.Annotation;

public class AnnotationScopeMetadataResolver
implements ScopeMetadataResolver {
    private final ScopedProxyMode defaultProxyMode;
    protected Class<? extends Annotation> scopeAnnotationType = Scope.class;

    public AnnotationScopeMetadataResolver() {
        this.defaultProxyMode = ScopedProxyMode.NO;
    }

    public AnnotationScopeMetadataResolver(ScopedProxyMode defaultProxyMode) {
        Assert.notNull((Object)defaultProxyMode, "'defaultProxyMode' must not be null");
        this.defaultProxyMode = defaultProxyMode;
    }

    public void setScopeAnnotationType(Class<? extends Annotation> scopeAnnotationType) {
        Assert.notNull(scopeAnnotationType, "'scopeAnnotationType' must not be null");
        this.scopeAnnotationType = scopeAnnotationType;
    }

    @Override
    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        AnnotatedBeanDefinition annDef;
        AnnotationAttributes attributes;
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition && (attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)(annDef = (AnnotatedBeanDefinition)definition).getMetadata(), this.scopeAnnotationType)) != null) {
            metadata.setScopeName(attributes.getString("value"));
            ScopedProxyMode proxyMode = (ScopedProxyMode)((Object)attributes.getEnum("proxyMode"));
            if (proxyMode == null || proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = this.defaultProxyMode;
            }
            metadata.setScopedProxyMode(proxyMode);
        }
        return metadata;
    }
}

