/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.access;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.context.ConfigurableApplicationContext;
import com.bmc.thirdparty.org.springframework.context.support.ClassPathXmlApplicationContext;
import com.bmc.thirdparty.org.springframework.core.io.support.ResourcePatternUtils;
import java.util.HashMap;
import java.util.Map;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefContext.xml";
    private static final Map<String, BeanFactoryLocator> instances = new HashMap<String, BeanFactoryLocator>();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        String resourceLocation = selector;
        if (resourceLocation == null) {
            resourceLocation = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl(resourceLocation)) {
            resourceLocation = "classpath*:" + resourceLocation;
        }
        Map<String, BeanFactoryLocator> map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl;
            if (logger.isTraceEnabled()) {
                logger.trace("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + instances.hashCode() + ", instances=" + instances);
            }
            if ((bfl = instances.get(resourceLocation)) == null) {
                bfl = new ContextSingletonBeanFactoryLocator(resourceLocation);
                instances.put(resourceLocation, bfl);
            }
            return bfl;
        }
    }

    protected ContextSingletonBeanFactoryLocator(String resourceLocation) {
        super(resourceLocation);
    }

    @Override
    protected BeanFactory createDefinition(String resourceLocation, String factoryKey) {
        return new ClassPathXmlApplicationContext(new String[]{resourceLocation}, false);
    }

    @Override
    protected void initializeDefinition(BeanFactory groupDef) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)groupDef).refresh();
        }
    }

    @Override
    protected void destroyDefinition(BeanFactory groupDef, String selector) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            if (logger.isTraceEnabled()) {
                logger.trace("Context group with selector '" + selector + "' being released, as there are no more references to it");
            }
            ((ConfigurableApplicationContext)groupDef).close();
        }
    }
}

