/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.cache.interceptor;

import com.bmc.thirdparty.org.springframework.aop.support.StaticMethodMatcherPointcut;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheOperationSource;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Method;

abstract class CacheOperationSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    CacheOperationSourcePointcut() {
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        CacheOperationSource cas = this.getCacheOperationSource();
        return cas != null && !CollectionUtils.isEmpty(cas.getCacheOperations(method, targetClass));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CacheOperationSourcePointcut)) {
            return false;
        }
        CacheOperationSourcePointcut otherPc = (CacheOperationSourcePointcut)other;
        return ObjectUtils.nullSafeEquals(this.getCacheOperationSource(), otherPc.getCacheOperationSource());
    }

    public int hashCode() {
        return CacheOperationSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getCacheOperationSource();
    }

    protected abstract CacheOperationSource getCacheOperationSource();
}

