/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.cache.interceptor;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheOperation;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheOperationSource;
import com.bmc.thirdparty.org.springframework.cache.interceptor.MethodCacheKey;
import com.bmc.thirdparty.org.springframework.core.BridgeMethodResolver;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractFallbackCacheOperationSource
implements CacheOperationSource {
    private static final Collection<CacheOperation> NULL_CACHING_ATTRIBUTE = Collections.emptyList();
    protected final Log logger = LogFactory.getLog(this.getClass());
    final Map<Object, Collection<CacheOperation>> attributeCache = new ConcurrentHashMap<Object, Collection<CacheOperation>>(1024);

    @Override
    public Collection<CacheOperation> getCacheOperations(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        Collection<CacheOperation> cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_CACHING_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        Collection<CacheOperation> cacheOps = this.computeCacheOperations(method, targetClass);
        if (cacheOps == null) {
            this.attributeCache.put(cacheKey, NULL_CACHING_ATTRIBUTE);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding cacheable method '" + method.getName() + "' with attribute: " + cacheOps);
            }
            this.attributeCache.put(cacheKey, cacheOps);
        }
        return cacheOps;
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new MethodCacheKey(method, targetClass);
    }

    private Collection<CacheOperation> computeCacheOperations(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
        Collection<CacheOperation> opDef = this.findCacheOperations(specificMethod = BridgeMethodResolver.findBridgedMethod(specificMethod));
        if (opDef != null) {
            return opDef;
        }
        opDef = this.findCacheOperations(specificMethod.getDeclaringClass());
        if (opDef != null) {
            return opDef;
        }
        if (specificMethod != method) {
            opDef = this.findCacheOperations(method);
            if (opDef != null) {
                return opDef;
            }
            return this.findCacheOperations(method.getDeclaringClass());
        }
        return null;
    }

    protected abstract Collection<CacheOperation> findCacheOperations(Method var1);

    protected abstract Collection<CacheOperation> findCacheOperations(Class<?> var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

