/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Autowire;
import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Configurable;
import com.bmc.thirdparty.org.springframework.beans.factory.wiring.BeanWiringInfo;
import com.bmc.thirdparty.org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;

public class AnnotationBeanWiringInfoResolver
implements BeanWiringInfoResolver {
    @Override
    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
        Assert.notNull(beanInstance, "Bean instance must not be null");
        Configurable annotation = beanInstance.getClass().getAnnotation(Configurable.class);
        return annotation != null ? this.buildWiringInfo(beanInstance, annotation) : null;
    }

    protected BeanWiringInfo buildWiringInfo(Object beanInstance, Configurable annotation) {
        if (!Autowire.NO.equals((Object)annotation.autowire())) {
            return new BeanWiringInfo(annotation.autowire().value(), annotation.dependencyCheck());
        }
        if (!"".equals(annotation.value())) {
            return new BeanWiringInfo(annotation.value(), false);
        }
        return new BeanWiringInfo(this.getDefaultBeanName(beanInstance), true);
    }

    protected String getDefaultBeanName(Object beanInstance) {
        return ClassUtils.getUserClass(beanInstance).getName();
    }
}

