/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.springframework.aop.SpringProxy;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.framework.AopConfigException;
import com.bmc.thirdparty.org.springframework.aop.framework.AopProxy;
import com.bmc.thirdparty.org.springframework.aop.framework.AopProxyFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.JdkDynamicAopProxy;
import com.bmc.thirdparty.org.springframework.aop.framework.ObjenesisCglibAopProxy;
import java.io.Serializable;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    @Override
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface()) {
                return new JdkDynamicAopProxy(config);
            }
            return new ObjenesisCglibAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] interfaces = config.getProxiedInterfaces();
        return interfaces.length == 0 || interfaces.length == 1 && SpringProxy.class.equals(interfaces[0]);
    }
}

