/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj.annotation;

import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.BeanFactoryAspectJAdvisorsBuilder;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.autoproxy.AspectJAwareAdvisorAutoProxyCreator;
import com.bmc.thirdparty.org.springframework.beans.factory.ListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AnnotationAwareAspectJAutoProxyCreator
extends AspectJAwareAdvisorAutoProxyCreator {
    private List<Pattern> includePatterns;
    private AspectJAdvisorFactory aspectJAdvisorFactory = new ReflectiveAspectJAdvisorFactory();
    private BeanFactoryAspectJAdvisorsBuilder aspectJAdvisorsBuilder;

    public void setIncludePatterns(List<String> patterns) {
        this.includePatterns = new ArrayList<Pattern>(patterns.size());
        for (String patternText : patterns) {
            this.includePatterns.add(Pattern.compile(patternText));
        }
    }

    public void setAspectJAdvisorFactory(AspectJAdvisorFactory aspectJAdvisorFactory) {
        Assert.notNull(aspectJAdvisorFactory, "AspectJAdvisorFactory must not be null");
        this.aspectJAdvisorFactory = aspectJAdvisorFactory;
    }

    @Override
    protected void initBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.initBeanFactory(beanFactory);
        this.aspectJAdvisorsBuilder = new BeanFactoryAspectJAdvisorsBuilderAdapter(beanFactory, this.aspectJAdvisorFactory);
    }

    @Override
    protected List<Advisor> findCandidateAdvisors() {
        List<Advisor> advisors = super.findCandidateAdvisors();
        advisors.addAll(this.aspectJAdvisorsBuilder.buildAspectJAdvisors());
        return advisors;
    }

    @Override
    protected boolean isInfrastructureClass(Class<?> beanClass) {
        return super.isInfrastructureClass(beanClass) || this.aspectJAdvisorFactory.isAspect(beanClass);
    }

    protected boolean isEligibleAspectBean(String beanName) {
        if (this.includePatterns == null) {
            return true;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }

    private class BeanFactoryAspectJAdvisorsBuilderAdapter
    extends BeanFactoryAspectJAdvisorsBuilder {
        public BeanFactoryAspectJAdvisorsBuilderAdapter(ListableBeanFactory beanFactory, AspectJAdvisorFactory advisorFactory) {
            super(beanFactory, advisorFactory);
        }

        @Override
        protected boolean isEligibleBean(String beanName) {
            return AnnotationAwareAspectJAutoProxyCreator.this.isEligibleAspectBean(beanName);
        }
    }
}

