/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj;

import com.bmc.thirdparty.org.springframework.aop.AfterAdvice;
import com.bmc.thirdparty.org.springframework.aop.AfterReturningAdvice;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AbstractAspectJAdvice;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectInstanceFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJExpressionPointcut;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class AspectJAfterReturningAdvice
extends AbstractAspectJAdvice
implements AfterReturningAdvice,
AfterAdvice {
    public AspectJAfterReturningAdvice(Method aspectJBeforeAdviceMethod, AspectJExpressionPointcut pointcut, AspectInstanceFactory aif) {
        super(aspectJBeforeAdviceMethod, pointcut, aif);
    }

    @Override
    public boolean isBeforeAdvice() {
        return false;
    }

    @Override
    public boolean isAfterAdvice() {
        return true;
    }

    @Override
    public void setReturningName(String name) {
        this.setReturningNameNoCheck(name);
    }

    @Override
    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        if (this.shouldInvokeOnReturnValueOf(method, returnValue)) {
            this.invokeAdviceMethod(this.getJoinPointMatch(), returnValue, null);
        }
    }

    private boolean shouldInvokeOnReturnValueOf(Method method, Object returnValue) {
        Class<?> type = this.getDiscoveredReturningType();
        Type genericType = this.getDiscoveredReturningGenericType();
        return this.matchesReturnValue(type, method, returnValue) && (genericType == null || genericType == type || TypeUtils.isAssignable(genericType, method.getGenericReturnType()));
    }

    private boolean matchesReturnValue(Class<?> type, Method method, Object returnValue) {
        if (returnValue != null) {
            return ClassUtils.isAssignableValue(type, returnValue);
        }
        if (type.equals(Object.class) && method.getReturnType().equals(Void.TYPE)) {
            return true;
        }
        return ClassUtils.isAssignable(type, method.getReturnType());
    }
}

