/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.ARCommonConfig;
import org.apache.log4j.Logger;

public class LogBytes {
    private static Logger log = Logger.getLogger(LogBytes.class);
    private static final boolean _DEBUG_ON = LogBytes.isDebugEnabled();
    private static boolean _lineBreak = false;

    private LogBytes() {
    }

    private static boolean isDebugEnabled() {
        return log.isDebugEnabled() && ARCommonConfig.getInstance().getLogBytes();
    }

    public static void printByteArrayAsHex(byte[] in, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        if (in == null || in.length == 0) {
            log.debug("Byte array is null!");
        } else {
            log.debug(msg);
            log.debug("Byte array as hex values : len = " + in.length);
            StringBuilder hex = new StringBuilder();
            for (int i = 0; i < in.length; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    log.debug(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("0").append(hStr).append(" ");
                    continue;
                }
                hex.append(hStr).append(" ");
            }
            log.debug(hex.toString());
        }
    }

    public static void printByteArrayAsHex(byte[] in, int start, int bytesToRead, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        int len = start + bytesToRead;
        if (in == null || in.length == 0 || bytesToRead <= 0 || in.length < bytesToRead) {
            log.debug("Did not indicate how many bytes to log from buffer: " + in.length);
        } else {
            log.debug(msg);
            StringBuilder hex = new StringBuilder();
            for (int i = start; i < len; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    log.debug(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("0").append(hStr).append(" ");
                    continue;
                }
                hex.append(hStr).append(" ");
            }
            log.debug(hex.toString());
        }
    }

    public static void printByteArrayAsHexArray(byte[] in, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        if (in == null || in.length == 0) {
            log.debug("Byte array is null!");
        } else {
            log.debug(msg);
            log.debug("Byte array as hex values : len = " + in.length);
            StringBuilder hex = new StringBuilder();
            hex.append("{");
            for (int i = 0; i < in.length; ++i) {
                if (_lineBreak && i % 8 == 0 && i != 0) {
                    log.debug(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("(byte)0x0").append(hStr).append(", ");
                    continue;
                }
                hex.append("(byte)0x").append(hStr).append(", ");
            }
            hex.append("}");
            log.debug(hex.toString());
        }
    }

    public static void printByteArrayAsChar(byte[] in, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        if (in == null || in.length == 0) {
            log.debug("Byte array as char:");
        } else {
            log.debug(msg);
            log.debug("Byte array as char values : len = " + in.length);
            StringBuilder strB = new StringBuilder();
            for (int i = 0; i != in.length; ++i) {
                strB.append((char)in[i]).append(" ");
            }
            log.debug(strB.toString());
        }
    }

    public static void printByteArray(byte[] in, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        if (in == null || in.length == 0) {
            log.debug("Byte array is null!");
        } else {
            log.debug(msg);
            log.debug("Byte array : len = " + in.length);
            StringBuilder strB = new StringBuilder();
            for (int i = 0; i < in.length; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    log.debug(strB.toString());
                    strB = new StringBuilder();
                }
                strB.append(in[i]).append(" ");
            }
            log.debug(strB.toString());
        }
    }

    public static void printByteArrayAsString(byte[] in, String msg) {
        if (!_DEBUG_ON) {
            return;
        }
        if (in == null || in.length == 0) {
            log.debug("Byte array is null!");
        } else {
            log.debug(msg);
            log.debug("Byte array : len = " + in.length);
            log.debug(new String(in));
        }
    }
}

