/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class LocaleUtil {
    public static final int DATETIME = 0;
    public static final int DATE_ONLY = 1;
    public static final int TIME_ONLY = 2;
    private static final int[] dateStyles = new int[]{3, 2, 1, 0};
    private static String customDateFormatPattern = null;
    private static String customTimeFormatPattern = null;
    private static String[] fmtStrings = new String[]{"H:mm:ss", "H:mm", ""};
    private static final char[] dtSepChars = new char[]{'/', '-', '.'};
    private static DateFormat dateFormat = null;
    private static DateFormat timeFormat = null;
    private static DateFormat dateTimeFormat = null;
    private static TimeZone m_timeZone = null;
    private static Locale _locale = null;
    private static final LocaleUtil localeUtil = new LocaleUtil();

    private LocaleUtil() {
        LocaleUtil.setLocale(Locale.getDefault());
    }

    public static String formatDate(Date date) {
        if (date != null) {
            return LocaleUtil.getDateFormat().format(date);
        }
        return LocaleUtil.getDateFormat().format(new Date());
    }

    public static String formatDateTime(Date date) {
        if (date != null) {
            return LocaleUtil.getDateFormat().format(date) + " " + LocaleUtil.getTimeFormat().format(date);
        }
        Date now = new Date();
        return LocaleUtil.getDateFormat().format(now) + " " + LocaleUtil.getTimeFormat().format(now);
    }

    public static String formatTime(Date date) {
        if (date != null) {
            return LocaleUtil.getTimeFormat().format(date);
        }
        return LocaleUtil.getTimeFormat().format(new Date());
    }

    public static String getCustomDateFormat() {
        return customDateFormatPattern;
    }

    public static String getCustomTimeFormat() {
        return customTimeFormatPattern;
    }

    private static DateFormat getDateTimeFormat() {
        if (dateTimeFormat == null) {
            LocaleUtil.setDateTimeFormat(((SimpleDateFormat)LocaleUtil.getDateFormat()).toPattern() + " " + ((SimpleDateFormat)LocaleUtil.getTimeFormat()).toPattern());
        }
        return dateTimeFormat;
    }

    public static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = customDateFormatPattern == null ? LocaleUtil.getDateFormat(3) : LocaleUtil.getDateFormat(customDateFormatPattern);
        }
        return dateFormat;
    }

    public static DateFormat getDateFormat(int style) {
        SimpleDateFormat simpleFormat;
        String pattern;
        DateFormat formatter = SimpleDateFormat.getDateInstance(style, _locale);
        if (style == 3 && formatter instanceof SimpleDateFormat && !(pattern = (simpleFormat = (SimpleDateFormat)formatter).toPattern()).contains("yyyy")) {
            pattern = pattern.replaceAll("yy", "yyyy");
            simpleFormat.applyPattern(pattern);
            formatter = simpleFormat;
        }
        formatter.setTimeZone(LocaleUtil.getTimeZone());
        return formatter;
    }

    public static DateFormat getDateFormat(String pattern) {
        if (pattern == null) {
            return LocaleUtil.getDateFormat();
        }
        DateFormat formatter = SimpleDateFormat.getDateInstance(2, _locale);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)formatter;
            simpleFormat.applyPattern(pattern);
            formatter = simpleFormat;
        }
        formatter.setTimeZone(LocaleUtil.getTimeZone());
        return formatter;
    }

    public static DateFormat getDateTimeFormat(int dateStyle, int timeStyle) {
        SimpleDateFormat simpleFormat;
        String pattern;
        DateFormat formatter = SimpleDateFormat.getDateTimeInstance(dateStyle, timeStyle, _locale);
        if (dateStyle == 3 && formatter instanceof SimpleDateFormat && !(pattern = (simpleFormat = (SimpleDateFormat)formatter).toPattern()).contains("yyyy")) {
            pattern = pattern.replaceAll("yy", "yyyy");
            simpleFormat.applyPattern(pattern);
            formatter = simpleFormat;
        }
        formatter.setTimeZone(LocaleUtil.getTimeZone());
        return formatter;
    }

    public static synchronized LocaleUtil getInstance() {
        return localeUtil;
    }

    public static Locale getLocale() {
        return _locale;
    }

    public static Locale parseLocale(String localeStr) {
        Locale locale = null;
        if (localeStr != null && !"".equals(localeStr)) {
            String[] tokens = localeStr.split("_");
            switch (tokens.length) {
                case 1: {
                    if (tokens[0] == null || tokens[0].equalsIgnoreCase("UTF-8")) break;
                    locale = new Locale(tokens[0]);
                    break;
                }
                case 2: {
                    int i = -1;
                    i = tokens[1].indexOf(".");
                    String region = i >= 0 ? tokens[1].substring(0, i) : tokens[1];
                    locale = new Locale(tokens[0], region);
                    break;
                }
            }
        }
        return locale;
    }

    public static DateFormat getTimeFormat() {
        if (timeFormat == null) {
            timeFormat = customTimeFormatPattern == null ? DateFormat.getTimeInstance() : LocaleUtil.getTimeFormat(customTimeFormatPattern);
        }
        return timeFormat;
    }

    public static DateFormat getTimeFormat(String customTimeFormat) {
        if (customTimeFormat == null) {
            return LocaleUtil.getTimeFormat();
        }
        DateFormat formatter = DateFormat.getTimeInstance();
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)formatter;
            simpleFormat.applyPattern(customTimeFormat);
            formatter = simpleFormat;
        }
        formatter.setTimeZone(LocaleUtil.getTimeZone());
        return formatter;
    }

    public static Date parseDateTime(String stringRepresentation, int type) {
        return LocaleUtil.parseDateTime(stringRepresentation, type, true);
    }

    public static Date parseDateTime(String stringRepresentation, int type, boolean lenient) {
        return LocaleUtil.parseDateTime(stringRepresentation, type, _locale, lenient);
    }

    public static Date parseDateTime(String stringRepresentation, int type, Locale locale) {
        return LocaleUtil.parseDateTime(stringRepresentation, type, locale, true);
    }

    public static Date parseDateTime(String stringRepresentation, int type, Locale locale, boolean lenient) {
        return LocaleUtil.parseDateTime(stringRepresentation, type, locale, true, null);
    }

    public static Date parseDateTime(String stringRepresentation, int type, Locale locale, boolean lenient, String timeZoneValue) {
        try {
            long time = Long.parseLong(stringRepresentation);
            if (stringRepresentation.length() == 10) {
                time *= 1000L;
            }
            return new Date(time);
        }
        catch (NumberFormatException numberFormatException) {
            char sep;
            TimeZone timeZone = timeZoneValue == null || timeZoneValue.equals("") ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneValue);
            Date date = null;
            date = LocaleUtil.parseDateTime(stringRepresentation, type, locale, '\u0000', timeZone);
            if (date != null) {
                return date;
            }
            char[] cArray = dtSepChars;
            int n = cArray.length;
            for (int i = 0; i < n && (date = LocaleUtil.parseDateTime(stringRepresentation, type, locale, sep = cArray[i], timeZone)) == null; ++i) {
            }
            return date;
        }
    }

    private static Date parseDateTime(String stringRepresentation, int type, Locale locale, char sepChar, TimeZone timeZone) {
        DateFormat dateFormat = null;
        Date date = null;
        boolean success = false;
        switch (type) {
            case 0: {
                if (LocaleUtil.getCustomDateFormat() != null || LocaleUtil.getCustomTimeFormat() != null) {
                    DateFormat df = LocaleUtil.getDateTimeFormat();
                    date = LocaleUtil.parseCustomDate(df, stringRepresentation, timeZone);
                }
                if (date != null) break;
                for (int i = 0; i < dateStyles.length && !success; ++i) {
                    int dtStyle = dateStyles[i];
                    DateFormat dtFormat = DateFormat.getDateInstance(dtStyle, locale);
                    dtFormat.setTimeZone(timeZone);
                    String datePattern = null;
                    if (dtFormat instanceof SimpleDateFormat) {
                        datePattern = ((SimpleDateFormat)dtFormat).toPattern();
                    }
                    for (int j = 0; j < dateStyles.length + fmtStrings.length && !success; ++j) {
                        ParsePosition parsePosition = new ParsePosition(0);
                        try {
                            if (j < dateStyles.length) {
                                dateFormat = DateFormat.getDateTimeInstance(dtStyle, dateStyles[j], locale);
                                dateFormat.setTimeZone(timeZone);
                                String dateTimePattern = null;
                                if (dateFormat instanceof SimpleDateFormat) {
                                    dateTimePattern = ((SimpleDateFormat)dateFormat).toPattern();
                                }
                                dateTimePattern = LocaleUtil.replaceDateSeparator(dateTimePattern, sepChar);
                                ((SimpleDateFormat)dateFormat).applyPattern(dateTimePattern);
                                dateFormat.setLenient(false);
                                dateFormat.setTimeZone(timeZone);
                                date = dateFormat.parse(stringRepresentation, parsePosition);
                                if (parsePosition.getIndex() != stringRepresentation.length()) continue;
                                success = true;
                                continue;
                            }
                            datePattern = LocaleUtil.replaceDateSeparator(datePattern, sepChar);
                            String formatStr = datePattern + " " + fmtStrings[j - dateStyles.length];
                            formatStr = formatStr.trim();
                            SimpleDateFormat sFormat = new SimpleDateFormat(formatStr, locale);
                            sFormat.setLenient(false);
                            sFormat.setTimeZone(timeZone);
                            date = sFormat.parse(stringRepresentation, parsePosition);
                            if (parsePosition.getIndex() != stringRepresentation.length()) continue;
                            success = true;
                            continue;
                        }
                        catch (Exception formatStr) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case 1: {
                if (LocaleUtil.getCustomDateFormat() != null) {
                    date = LocaleUtil.parseCustomDate(LocaleUtil.getDateFormat(), stringRepresentation, timeZone);
                }
                if (date != null) break;
                String patternStr = null;
                for (int i = 0; i < dateStyles.length && !success; ++i) {
                    int dtStyle = dateStyles[i];
                    try {
                        dateFormat = DateFormat.getDateInstance(dtStyle, locale);
                        if (dateFormat instanceof SimpleDateFormat) {
                            patternStr = ((SimpleDateFormat)dateFormat).toPattern();
                        }
                        patternStr = LocaleUtil.replaceDateSeparator(patternStr, sepChar);
                        ((SimpleDateFormat)dateFormat).applyPattern(patternStr);
                        dateFormat.setLenient(false);
                        dateFormat.setTimeZone(timeZone);
                        date = dateFormat.parse(stringRepresentation);
                        success = true;
                        DateFormatSymbols dtSymbols = ((SimpleDateFormat)dateFormat).getDateFormatSymbols();
                        String[] eras = dtSymbols.getEras();
                        if (stringRepresentation.indexOf(eras[0]) <= -1) continue;
                        Calendar cal = Calendar.getInstance(locale);
                        cal.setTime(date);
                        cal.set(1, -(cal.get(1) - 1));
                        return cal.getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                break;
            }
            case 2: {
                int i;
                if (LocaleUtil.getCustomTimeFormat() != null) {
                    date = LocaleUtil.parseCustomDate(LocaleUtil.getTimeFormat(), stringRepresentation, timeZone);
                }
                if (date != null) break;
                for (i = 0; i < dateStyles.length && !success; ++i) {
                    int tmStyle = dateStyles[i];
                    dateFormat = DateFormat.getTimeInstance(tmStyle, locale);
                    dateFormat.setLenient(false);
                    ParsePosition pos = new ParsePosition(0);
                    date = dateFormat.parse(stringRepresentation, pos);
                    if (pos.getIndex() != stringRepresentation.length()) continue;
                    success = true;
                }
                if (success) break;
                for (i = 0; i < fmtStrings.length && !success; ++i) {
                    try {
                        dateFormat = new SimpleDateFormat(fmtStrings[i], locale);
                        ParsePosition parsePosition = new ParsePosition(0);
                        dateFormat.setLenient(false);
                        dateFormat.setTimeZone(timeZone);
                        date = dateFormat.parse(stringRepresentation, parsePosition);
                        if (parsePosition.getIndex() == stringRepresentation.length()) {
                            success = true;
                            continue;
                        }
                        date = null;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        return date;
    }

    public static void setCustomDateFormat(String pattern) {
        customDateFormatPattern = pattern;
        LocaleUtil.setDateFormat(LocaleUtil.getDateFormat(pattern));
    }

    public static void setCustomTimeFormat(String pattern) {
        customTimeFormatPattern = pattern;
        LocaleUtil.setTimeFormat(LocaleUtil.getTimeFormat(pattern));
    }

    private static void setDateTimeFormat(String customDateTimeFormatPattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(customDateTimeFormatPattern, LocaleUtil.getLocale());
            dateTimeFormat = sdf;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDateFormat(DateFormat format) {
        dateFormat = format;
    }

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    public static void setLocale(String locale) {
        _locale = LocaleUtil.parseLocale(locale);
        if (_locale == null) {
            _locale = Locale.getDefault();
        }
    }

    public static void setTimeZone(String timeZone) {
        m_timeZone = LocaleUtil.parseTimeZone(timeZone);
    }

    public static TimeZone parseTimeZone(String timeZone) {
        return timeZone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone);
    }

    private static TimeZone getTimeZone() {
        if (m_timeZone == null) {
            m_timeZone = TimeZone.getDefault();
        }
        return m_timeZone;
    }

    public static void setTimeFormat(DateFormat format) {
        timeFormat = format;
    }

    private static String replaceDateSeparator(String pattern, char separator) {
        StringBuffer result = new StringBuffer(pattern.length());
        if (separator != '\u0000' && pattern.indexOf(separator) == -1) {
            char[] arrPattern = pattern.toCharArray();
            char c = '\u0000';
            for (int i = 0; i < arrPattern.length; ++i) {
                boolean b = false;
                c = arrPattern[i];
                for (char x : dtSepChars) {
                    if (c != x) continue;
                    b = true;
                    if (arrPattern.length <= i + 1 || arrPattern[i + 1] != ' ') break;
                    ++i;
                    break;
                }
                result.append(b ? separator : c);
            }
        } else {
            result = new StringBuffer(pattern);
        }
        return result.toString();
    }

    private static Date parseCustomDate(DateFormat dateFormat, String stringRepresentation, TimeZone timeZone) {
        String pattern = null;
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat customDateFormat = (SimpleDateFormat)dateFormat;
            pattern = customDateFormat.toPattern();
        }
        if (pattern != null && pattern.indexOf("yyyy") > -1) {
            SimpleDateFormat simpleDateFmt = new SimpleDateFormat(pattern.replace("yyyy", "yy"));
            dateFormat = simpleDateFmt;
        }
        dateFormat.setTimeZone(timeZone);
        dateFormat.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date date = dateFormat.parse(stringRepresentation, pos);
        return pos.getIndex() == stringRepresentation.length() ? date : null;
    }
}

