/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.CharDataEncryption;
import com.bmc.arsys.arencrypt.JCECheck;
import com.bmc.arsys.utils.ARConfigPersistence;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ARMachineGUID {
    private static Logger logger = Logger.getLogger(ARMachineGUID.class);
    private static String exactGuidStr = "";

    private ARMachineGUID() {
    }

    public static String setMachineGuid() {
        String guidToRtn;
        boolean persisted;
        String machineGuid;
        String encrytedMachineGuid;
        block12: {
            encrytedMachineGuid = null;
            machineGuid = null;
            byte[] encryptedBuf = null;
            boolean isValidGuid = false;
            persisted = true;
            String storedIDValue = null;
            guidToRtn = null;
            try {
                storedIDValue = ARConfigPersistence.retrieveStoredKey("SOFTWARE\\Remedy\\ARServer", "apisourceid", null);
                CharDataEncryption charEnc = new CharDataEncryption(true, false);
                charEnc.setPasswordKeyForEncryption(0);
                if (storedIDValue != null) {
                    try {
                        machineGuid = new String(charEnc.decryptCharData(storedIDValue.getBytes()));
                        isValidGuid = ARMachineGUID.validateMachineGuid(machineGuid);
                        exactGuidStr = ARMachineGUID.getGUID(machineGuid);
                        encrytedMachineGuid = storedIDValue;
                        guidToRtn = exactGuidStr;
                    }
                    catch (AREncryptionException e) {
                        isValidGuid = false;
                    }
                }
                if (storedIDValue != null && isValidGuid) break block12;
                machineGuid = ARMachineGUID.generateMachineSourceGUID();
                guidToRtn = exactGuidStr;
                try {
                    encryptedBuf = charEnc.encryptCharData(machineGuid.getBytes());
                    if (exactGuidStr.length() > 128) {
                        persisted = false;
                        logger.error("Generated and encrypted machineGUID " + encryptedBuf.length + " bytes exceeded limit AR_MAX_USER_GUID_SIZE " + 128);
                        break block12;
                    }
                    encrytedMachineGuid = new String(encryptedBuf);
                    persisted = ARConfigPersistence.persistKeyValue("SOFTWARE\\Remedy\\ARServer", "apisourceid", encrytedMachineGuid);
                }
                catch (AREncryptionException e) {
                    persisted = false;
                    logger.debug(e);
                    if ((e.getErrorNum() == 9010 || e.getErrorNum() == 9011) && logger.isDebugEnabled()) {
                        JCECheck.printJCE(false, false);
                    }
                }
            }
            catch (AREncryptionException e1) {
                persisted = false;
                logger.debug("Encryption error for machineGuid " + e1.getErrorNum());
            }
            catch (Exception e2) {
                persisted = false;
                logger.debug("General exception with machineGuid " + e2);
            }
        }
        if (persisted && encrytedMachineGuid != null) {
            machineGuid = encrytedMachineGuid;
            guidToRtn = exactGuidStr;
        } else {
            machineGuid = "";
            guidToRtn = "";
        }
        return guidToRtn;
    }

    private static String getGUID(String ID) {
        StringTokenizer strTok = new StringTokenizer(ID, ",");
        String guidStr = null;
        while (strTok.hasMoreElements()) {
            guidStr = strTok.nextElement().toString();
        }
        return guidStr;
    }

    static String generateMachineSourceGUID() {
        StringBuilder guidStr = new StringBuilder();
        guidStr.append("1").append(",").append(ARMachineGUID.getHostByName()).append(",").append("AP");
        Random rnd = new Random();
        long uniqueNum = (System.currentTimeMillis() >>> 16 << 16) + (long)rnd.nextInt();
        guidStr.append(uniqueNum);
        exactGuidStr = "AP" + uniqueNum;
        return guidStr.toString();
    }

    static boolean validateMachineGuid(String machineGuid) {
        return machineGuid.contains(ARMachineGUID.getHostByName());
    }

    static String getHostByName() {
        String rst = null;
        try {
            rst = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            try {
                rst = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                logger.error("machineGuid can not get hostname nor hostaddress");
            }
        }
        return rst;
    }
}

